/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.renderer;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.filter.ConcreteGraphicsNodeRableFactory;
import org.apache.batik.gvt.renderer.Renderer;
import org.apache.batik.gvt.renderer.StrokingTextPainter;

public class StaticRenderer
implements Renderer {
    private static final String ILLEGAL_ARGUMENT_NULL_OFFSCREEN = "offScreen should not be null";
    private static final String ILLEGAL_ARGUMENT_ZERO_WIDTH_OR_HEIGHT = "offScreen should have positive width/height";
    protected GraphicsNode treeRoot;
    private boolean progressivePaintAllowed;
    private Selector textSelector = null;
    protected BufferedImage offScreen;
    protected GraphicsNodeRenderContext nodeRenderContext;
    protected AffineTransform usr2dev;

    public StaticRenderer(BufferedImage bufferedImage, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.setOffScreen(bufferedImage);
        this.setRenderContext(graphicsNodeRenderContext);
    }

    public StaticRenderer(BufferedImage bufferedImage) {
        this.setOffScreen(bufferedImage);
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        StrokingTextPainter strokingTextPainter = new StrokingTextPainter();
        ConcreteGraphicsNodeRableFactory concreteGraphicsNodeRableFactory = new ConcreteGraphicsNodeRableFactory();
        this.nodeRenderContext = new GraphicsNodeRenderContext(new AffineTransform(), null, renderingHints, fontRenderContext, strokingTextPainter, concreteGraphicsNodeRableFactory);
    }

    public void setRenderContext(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        this.nodeRenderContext = graphicsNodeRenderContext;
    }

    public GraphicsNodeRenderContext getRenderContext() {
        return this.nodeRenderContext;
    }

    public void setOffScreen(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_NULL_OFFSCREEN);
        }
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            throw new IllegalArgumentException("offScreen should have positive width/height : offScreen.getWidth() = " + bufferedImage.getWidth() + " / offScreen.getHeight() = " + bufferedImage.getHeight());
        }
        this.offScreen = bufferedImage;
    }

    public void dispose() {
        this.offScreen = null;
        this.treeRoot = null;
        this.nodeRenderContext = null;
    }

    public void setTree(GraphicsNode graphicsNode) {
        this.treeRoot = graphicsNode;
    }

    public GraphicsNode getTree() {
        return this.treeRoot;
    }

    public void repaint(Shape shape) throws InterruptedException {
        if (shape == null) {
            return;
        }
        this.nodeRenderContext.setTransform(this.usr2dev);
        this.nodeRenderContext.setAreaOfInterest(shape);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(this.offScreen, this.nodeRenderContext.getRenderingHints());
        graphics2D.transform(this.nodeRenderContext.getTransform());
        graphics2D.clip(this.nodeRenderContext.getAreaOfInterest());
        if (this.treeRoot != null) {
            this.treeRoot.paint(graphics2D, this.nodeRenderContext);
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        this.usr2dev = affineTransform;
        this.nodeRenderContext.setTransform(affineTransform);
    }

    public AffineTransform getTransform() {
        return this.nodeRenderContext.getTransform();
    }

    public boolean isProgressivePaintAllowed() {
        return this.progressivePaintAllowed;
    }

    public void setProgressivePaintAllowed(boolean bl) {
        this.progressivePaintAllowed = bl;
    }
}

