/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.ShapePainter;

public class StrokeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected Stroke stroke;
    protected Paint paint;

    public StrokeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void paint(Graphics2D graphics2D, GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.stroke != null && this.paint != null) {
            graphics2D.setPaint(this.paint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.shape);
        }
    }

    public Shape getPaintedArea(GraphicsNodeRenderContext graphicsNodeRenderContext) {
        if (this.paint != null && this.stroke != null) {
            return this.stroke.createStrokedShape(this.shape);
        }
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

