/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class PadRed
extends AbstractRed {
    static final boolean DEBUG = false;
    PadMode padMode;
    RenderingHints hints;

    public PadRed(CachableRed cachableRed, Rectangle rectangle, PadMode padMode, RenderingHints renderingHints) {
        super(cachableRed, rectangle, cachableRed.getColorModel(), PadRed.fixSampleModel(cachableRed, rectangle), rectangle.x, rectangle.y, null);
        this.padMode = padMode;
        this.hints = renderingHints;
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        if (rectangle2.intersects(rectangle)) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
            cachableRed.copyData(writableRaster2);
        }
        if (this.padMode == PadMode.ZERO_PAD) {
            this.handleZero(writableRaster);
        } else if (this.padMode == PadMode.REPLICATE) {
            this.handleReplicate(writableRaster);
        } else if (this.padMode == PadMode.WRAP) {
            this.handleWrap(writableRaster);
        }
        return writableRaster;
    }

    protected void handleZero(WritableRaster writableRaster) {
        int n;
        int n2;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        ZeroRecter zeroRecter = ZeroRecter.getZeroRecter(writableRaster);
        Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        Rectangle rectangle4 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        if (rectangle3.x < rectangle.x) {
            n2 = rectangle.x - rectangle3.x;
            if (n2 > rectangle3.width) {
                n2 = rectangle3.width;
            }
            rectangle4.width = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.x += n2;
            rectangle3.width -= n2;
        }
        if (rectangle3.y < rectangle.y) {
            n2 = rectangle.y - rectangle3.y;
            if (n2 > rectangle3.height) {
                n2 = rectangle3.height;
            }
            rectangle4.x = rectangle3.x;
            rectangle4.y = rectangle3.y;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.y += n2;
            rectangle3.height -= n2;
        }
        if (rectangle3.y + rectangle3.height > rectangle.y + rectangle.height) {
            n2 = rectangle3.y + rectangle3.height - (rectangle.y + rectangle.height);
            if (n2 > rectangle3.height) {
                n2 = rectangle3.height;
            }
            n = rectangle3.y + rectangle3.height - n2;
            rectangle4.x = rectangle3.x;
            rectangle4.y = n;
            rectangle4.width = rectangle3.width;
            rectangle4.height = n2;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.height -= n2;
        }
        if (rectangle3.x + rectangle3.width > rectangle.x + rectangle.width) {
            n2 = rectangle3.x + rectangle3.width - (rectangle.x + rectangle.width);
            if (n2 > rectangle3.width) {
                n2 = rectangle3.width;
            }
            rectangle4.x = n = rectangle3.x + rectangle3.width - n2;
            rectangle4.y = rectangle3.y;
            rectangle4.width = n2;
            rectangle4.height = rectangle3.height;
            zeroRecter.zeroRect(rectangle4);
            rectangle3.width -= n2;
        }
    }

    protected void handleReplicate(WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4;
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        Rectangle rectangle = cachableRed.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        int n5 = rectangle2.x;
        int n6 = rectangle2.y;
        int n7 = rectangle2.width;
        int n8 = rectangle2.height;
        Rectangle rectangle3 = rectangle2.intersects(rectangle) ? rectangle2.intersection(rectangle) : new Rectangle(0, 0, 0, 0);
        if (n6 < rectangle.y) {
            n4 = rectangle3.width;
            n3 = rectangle3.x;
            n2 = rectangle3.x;
            n = n6;
            if (n5 + n7 - 1 <= rectangle.x) {
                n4 = 1;
                n3 = rectangle.x;
                n2 = n5 + n7 - 1;
            } else if (n5 >= rectangle.x + rectangle.width) {
                n4 = 1;
                n3 = rectangle.x + rectangle.width - 1;
                n2 = n5;
            }
            WritableRaster writableRaster2 = writableRaster.createWritableChild(n2, n, n4, 1, n3, rectangle.y, null);
            cachableRed.copyData(writableRaster2);
            ++n;
            int n9 = rectangle.y;
            if (n6 + n8 < n9) {
                n9 = n6 + n8;
            }
            if (n < n9) {
                int[] nArray = writableRaster.getPixels(n2, n - 1, n4, 1, (int[])null);
                while (n < rectangle.y) {
                    writableRaster.setPixels(n2, n, n4, 1, nArray);
                    ++n;
                }
            }
        }
        if (n6 + n8 > rectangle.y + rectangle.height) {
            n4 = rectangle3.width;
            n3 = rectangle3.x;
            n2 = rectangle.y + rectangle.height - 1;
            n = rectangle3.x;
            int n10 = rectangle.y + rectangle.height;
            if (n10 < n6) {
                n10 = n6;
            }
            if (n5 + n7 <= rectangle.x) {
                n4 = 1;
                n3 = rectangle.x;
                n = n5 + n7 - 1;
            } else if (n5 >= rectangle.x + rectangle.width) {
                n4 = 1;
                n3 = rectangle.x + rectangle.width - 1;
                n = n5;
            }
            WritableRaster writableRaster3 = writableRaster.createWritableChild(n, n10, n4, 1, n3, n2, null);
            cachableRed.copyData(writableRaster3);
            int n11 = n6 + n8;
            if (++n10 < n11) {
                int[] nArray = writableRaster.getPixels(n, n10 - 1, n4, 1, (int[])null);
                while (n10 < n11) {
                    writableRaster.setPixels(n, n10, n4, 1, nArray);
                    ++n10;
                }
            }
        }
        if (n5 < rectangle.x) {
            n4 = rectangle.x;
            if (n5 + n7 <= rectangle.x) {
                n4 = n5 + n7 - 1;
            }
            n3 = n5;
            int[] nArray = writableRaster.getPixels(n4, n6, 1, n8, (int[])null);
            while (n3 < n4) {
                writableRaster.setPixels(n3, n6, 1, n8, nArray);
                ++n3;
            }
        }
        if (n5 + n7 > rectangle.x + rectangle.width) {
            n4 = rectangle.x + rectangle.width - 1;
            if (n5 >= rectangle.x + rectangle.width) {
                n4 = n5;
            }
            n3 = n4 + 1;
            int n12 = n5 + n7 - 1;
            int[] nArray = writableRaster.getPixels(n4, n6, 1, n8, (int[])null);
            while (n3 < n12) {
                writableRaster.setPixels(n3, n6, 1, n8, nArray);
                ++n3;
            }
        }
    }

    protected void handleWrap(WritableRaster writableRaster) {
        this.handleZero(writableRaster);
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed, Rectangle rectangle) {
        int n;
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n2 = sampleModel.getWidth();
        if (n2 < 256) {
            n2 = 256;
        }
        if (n2 > rectangle.width) {
            n2 = rectangle.width;
        }
        if ((n = sampleModel.getHeight()) < 256) {
            n = 256;
        }
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        return sampleModel.createCompatibleSampleModel(n2, n);
    }

    protected static class ZeroRecter_INT_PACK
    extends ZeroRecter {
        final int base;
        final int scanStride;
        final int[] pixels;

        public ZeroRecter_INT_PACK(WritableRaster writableRaster) {
            super(writableRaster);
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            this.scanStride = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.base = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(0 - writableRaster.getSampleModelTranslateX(), 0 - writableRaster.getSampleModelTranslateY());
            this.pixels = dataBufferInt.getBankData()[0];
        }

        public void zeroRect(Rectangle rectangle) {
            int n = this.base + rectangle.x + rectangle.y * this.scanStride;
            if (rectangle.width > 10 && rectangle.height > 5) {
                int[] nArray = new int[rectangle.width];
                int n2 = 0;
                while (n2 < rectangle.height) {
                    int n3 = n + n2 * this.scanStride;
                    System.arraycopy(nArray, 0, this.pixels, n3, nArray.length);
                    ++n2;
                }
            } else {
                int n4 = 0;
                while (n4 < rectangle.height) {
                    int n5 = n + n4 * this.scanStride;
                    int n6 = n5 + rectangle.width;
                    while (n5 < n6) {
                        this.pixels[n5++] = 0;
                    }
                    ++n4;
                }
            }
        }
    }

    protected static class ZeroRecter {
        WritableRaster wr;
        int bands;

        public ZeroRecter(WritableRaster writableRaster) {
            this.wr = writableRaster;
            this.bands = writableRaster.getSampleModel().getNumBands();
        }

        public void zeroRect(Rectangle rectangle) {
            int[] nArray = new int[rectangle.width * this.bands];
            int n = 0;
            while (n < rectangle.height) {
                this.wr.setPixels(rectangle.x, rectangle.y + n, rectangle.width, 1, nArray);
                ++n;
            }
        }

        public static ZeroRecter getZeroRecter(WritableRaster writableRaster) {
            if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
                return new ZeroRecter_INT_PACK(writableRaster);
            }
            return new ZeroRecter(writableRaster);
        }
    }
}

