/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.Map;
import org.apache.batik.dom.svg.DefaultAttributeValueProducer;
import org.apache.batik.dom.svg.SVGOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedEnumeration;

public class SVGOMAnimatedEnumeration
implements SVGAnimatedEnumeration {
    protected static final Short[] SHORTS = new Short[]{new Short(0), new Short(1), new Short(2), new Short(3), new Short(4), new Short(5), new Short(6), new Short(7), new Short(8), new Short(9)};
    protected SVGOMElement element;
    protected String attributeNsURI;
    protected String attributeName;
    protected Map stringShortMap;
    protected Map shortStringMap;
    protected DefaultAttributeValueProducer defaultValueProducer;

    public SVGOMAnimatedEnumeration(SVGOMElement sVGOMElement, String string, String string2, Map map, Map map2, DefaultAttributeValueProducer defaultAttributeValueProducer) {
        this.element = sVGOMElement;
        this.attributeNsURI = string;
        this.attributeName = string2;
        this.stringShortMap = map;
        this.shortStringMap = map2;
        this.defaultValueProducer = defaultAttributeValueProducer;
    }

    public static Short createShort(short s) {
        if (s < 0 || s >= SHORTS.length) {
            return new Short(s);
        }
        return SHORTS[s];
    }

    public short getBaseVal() {
        Attr attr = this.element.getAttributeNodeNS(this.attributeNsURI, this.attributeName);
        if (attr != null) {
            Short s = (Short)this.stringShortMap.get(attr.getValue());
            if (s != null) {
                return s;
            }
        } else if (this.defaultValueProducer != null) {
            String string = this.defaultValueProducer.getDefaultAttributeValue();
            return (Short)this.stringShortMap.get(string);
        }
        return 0;
    }

    public void setBaseVal(short s) throws DOMException {
        if (s == 0 || s > this.shortStringMap.size()) {
            this.element.setAttributeNS(this.attributeNsURI, this.attributeName, "");
        }
        this.element.setAttributeNS(this.attributeNsURI, this.attributeName, (String)this.shortStringMap.get(SVGOMAnimatedEnumeration.createShort(s)));
    }

    public short getAnimVal() {
        throw new RuntimeException(" !!! TODO: SVGOMAnimatedEnumeration.getAnimVal()");
    }
}

