/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.HashSet;
import java.util.Set;
import org.apache.batik.dom.util.CSSStyleDeclarationFactory;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public class ElementNonCSSPresentationalHintsSupport
implements CSSConstants {
    public static final Set PRESENTATION_ATTRIBUTES = new HashSet();

    public static CSSStyleDeclaration getNonCSSPresentationalHints(Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = namedNodeMap.item(n2);
            String string = node.getNodeName();
            if (PRESENTATION_ATTRIBUTES.contains(string)) {
                if (cSSStyleDeclaration == null) {
                    DOMImplementation dOMImplementation = element.getOwnerDocument().getImplementation();
                    CSSStyleDeclarationFactory cSSStyleDeclarationFactory = (CSSStyleDeclarationFactory)((Object)dOMImplementation);
                    cSSStyleDeclaration = cSSStyleDeclarationFactory.createCSSStyleDeclaration();
                }
                cSSStyleDeclaration.setProperty(string, node.getNodeValue(), "");
            }
            ++n2;
        }
        return cSSStyleDeclaration;
    }

    static {
        PRESENTATION_ATTRIBUTES.add("alignment-baseline");
        PRESENTATION_ATTRIBUTES.add("baseline-shift");
        PRESENTATION_ATTRIBUTES.add("clip");
        PRESENTATION_ATTRIBUTES.add("clip-path");
        PRESENTATION_ATTRIBUTES.add("clip-rule");
        PRESENTATION_ATTRIBUTES.add("color");
        PRESENTATION_ATTRIBUTES.add("color-interpolation");
        PRESENTATION_ATTRIBUTES.add("color-profile");
        PRESENTATION_ATTRIBUTES.add("color-rendering");
        PRESENTATION_ATTRIBUTES.add("cursor");
        PRESENTATION_ATTRIBUTES.add("direction");
        PRESENTATION_ATTRIBUTES.add("display");
        PRESENTATION_ATTRIBUTES.add("dominant-baseline");
        PRESENTATION_ATTRIBUTES.add("enable-background");
        PRESENTATION_ATTRIBUTES.add("fill");
        PRESENTATION_ATTRIBUTES.add("fill-opacity");
        PRESENTATION_ATTRIBUTES.add("fill-rule");
        PRESENTATION_ATTRIBUTES.add("filter");
        PRESENTATION_ATTRIBUTES.add("flood-color");
        PRESENTATION_ATTRIBUTES.add("flood-opacity");
        PRESENTATION_ATTRIBUTES.add("font-family");
        PRESENTATION_ATTRIBUTES.add("font-size");
        PRESENTATION_ATTRIBUTES.add("font-size-adjust");
        PRESENTATION_ATTRIBUTES.add("font-stretch");
        PRESENTATION_ATTRIBUTES.add("font-style");
        PRESENTATION_ATTRIBUTES.add("font-variant");
        PRESENTATION_ATTRIBUTES.add("font-weight");
        PRESENTATION_ATTRIBUTES.add("glyph-orientation-horizontal");
        PRESENTATION_ATTRIBUTES.add("glyph-orientation-vertical");
        PRESENTATION_ATTRIBUTES.add("image-rendering");
        PRESENTATION_ATTRIBUTES.add("letter-spacing");
        PRESENTATION_ATTRIBUTES.add("lighting-color");
        PRESENTATION_ATTRIBUTES.add("marker");
        PRESENTATION_ATTRIBUTES.add("marker-end");
        PRESENTATION_ATTRIBUTES.add("marker-mid");
        PRESENTATION_ATTRIBUTES.add("marker-start");
        PRESENTATION_ATTRIBUTES.add("mask");
        PRESENTATION_ATTRIBUTES.add("opacity");
        PRESENTATION_ATTRIBUTES.add("overflow");
        PRESENTATION_ATTRIBUTES.add("pointer-events");
        PRESENTATION_ATTRIBUTES.add("shape-rendering");
        PRESENTATION_ATTRIBUTES.add("stop-color");
        PRESENTATION_ATTRIBUTES.add("stop-opacity");
        PRESENTATION_ATTRIBUTES.add("stroke");
        PRESENTATION_ATTRIBUTES.add("stroke-dasharray");
        PRESENTATION_ATTRIBUTES.add("stroke-dashoffset");
        PRESENTATION_ATTRIBUTES.add("stroke-linecap");
        PRESENTATION_ATTRIBUTES.add("stroke-linejoin");
        PRESENTATION_ATTRIBUTES.add("stroke-miterlimit");
        PRESENTATION_ATTRIBUTES.add("stroke-opacity");
        PRESENTATION_ATTRIBUTES.add("stroke-width");
        PRESENTATION_ATTRIBUTES.add("text-anchor");
        PRESENTATION_ATTRIBUTES.add("text-decoration");
        PRESENTATION_ATTRIBUTES.add("text-rendering");
        PRESENTATION_ATTRIBUTES.add("unicode-bidi");
        PRESENTATION_ATTRIBUTES.add("visibility");
        PRESENTATION_ATTRIBUTES.add("word-spacing");
        PRESENTATION_ATTRIBUTES.add("writing-mode");
    }
}

