/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.svg.SVGCSSNumberList;
import org.apache.batik.css.svg.SVGImmutableValue;
import org.apache.batik.css.value.AbstractImmutableValue;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGNumberList;

public class ImmutableSVGColorValue
extends AbstractImmutableValue
implements SVGImmutableValue,
RGBColor,
SVGICCColor {
    protected short colorType;
    protected CSSPrimitiveValue red;
    protected CSSPrimitiveValue green;
    protected CSSPrimitiveValue blue;
    protected String colorProfile;
    protected SVGCSSNumberList colors;

    public ImmutableSVGColorValue(short s, CSSPrimitiveValue cSSPrimitiveValue, CSSPrimitiveValue cSSPrimitiveValue2, CSSPrimitiveValue cSSPrimitiveValue3, String string, SVGCSSNumberList sVGCSSNumberList) {
        this.colorType = s;
        this.red = cSSPrimitiveValue;
        this.green = cSSPrimitiveValue2;
        this.blue = cSSPrimitiveValue3;
        this.colorProfile = string;
        this.colors = sVGCSSNumberList;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImmutableSVGColorValue)) {
            return false;
        }
        ImmutableSVGColorValue immutableSVGColorValue = (ImmutableSVGColorValue)object;
        if (this.colorType != immutableSVGColorValue.colorType) {
            return false;
        }
        if (this.red != null ? !this.red.equals(immutableSVGColorValue.red) || !this.green.equals(immutableSVGColorValue.green) || !this.blue.equals(immutableSVGColorValue.blue) : immutableSVGColorValue.red != null) {
            return false;
        }
        if (this.colorProfile != null ? this.colorProfile.equals(immutableSVGColorValue.colorProfile) : immutableSVGColorValue.colorProfile != null) {
            return false;
        }
        if (this.colors != null) {
            return this.colors.equals(immutableSVGColorValue.colors);
        }
        return immutableSVGColorValue.colors == null;
    }

    public ImmutableValue createReadOnlyCopy() {
        return new ImmutableSVGColorValue(this.colorType, this.red == null ? null : ((CSSOMValue)this.red).createReadOnlyCopy(), this.green == null ? null : ((CSSOMValue)this.green).createReadOnlyCopy(), this.blue == null ? null : ((CSSOMValue)this.blue).createReadOnlyCopy(), this.colorProfile, this.colors == null ? null : this.colors.createReadOnlyCopy());
    }

    public String getCssText() {
        switch (this.colorType) {
            case 1: {
                return "rgb(" + this.red.getCssText() + ", " + this.green.getCssText() + ", " + this.blue.getCssText() + ")";
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("rgb(").append(this.red.getCssText()).append(", ").append(this.green.getCssText()).append(", ").append(this.blue.getCssText()).append(") icc-color(").append(this.colorProfile);
                if (this.colors.getNumberOfItems() != 0) {
                    stringBuffer.append(", ").append(this.colors.toString());
                }
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.primitive.unit", new Object[]{new Integer(this.colorType)});
    }

    public short getPaintType() {
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.value", null);
    }

    public String getUri() {
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.value", null);
    }

    public short getColorType() {
        return this.colorType;
    }

    public RGBColor getRGBColor() {
        return this;
    }

    public SVGICCColor getICCColor() {
        return this;
    }

    public CSSPrimitiveValue getRed() {
        return this.red;
    }

    public CSSPrimitiveValue getGreen() {
        return this.green;
    }

    public CSSPrimitiveValue getBlue() {
        return this.blue;
    }

    public String getColorProfile() {
        return this.colorProfile;
    }

    public void setColorProfile(String string) throws DOMException {
    }

    public SVGNumberList getColors() {
        return this.colors;
    }
}

