/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.svg.SVGValueConstants;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class GlyphOrientationHorizontalFactory
extends AbstractValueFactory {
    public GlyphOrientationHorizontalFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "glyph-orientation-horizontal";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 13: {
                int n = lexicalUnit.getIntegerValue();
                switch (n) {
                    case -360: {
                        return SVGValueConstants.NUMBER_MINUS_360;
                    }
                    case -270: {
                        return SVGValueConstants.NUMBER_MINUS_270;
                    }
                    case -180: {
                        return SVGValueConstants.NUMBER_MINUS_180;
                    }
                    case -90: {
                        return SVGValueConstants.NUMBER_MINUS_90;
                    }
                    case 0: {
                        return SVGValueConstants.NUMBER_0;
                    }
                    case 90: {
                        return SVGValueConstants.NUMBER_90;
                    }
                    case 180: {
                        return SVGValueConstants.NUMBER_180;
                    }
                    case 270: {
                        return SVGValueConstants.NUMBER_270;
                    }
                    case 360: {
                        return SVGValueConstants.NUMBER_360;
                    }
                }
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.number", new Object[]{new Integer(n)});
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType())});
    }

    public ImmutableValue createFloatValue(short s, float f) throws DOMException {
        int n;
        if (s == 1 && f == (float)(n = (int)f)) {
            switch (n) {
                case -360: {
                    return SVGValueConstants.NUMBER_MINUS_360;
                }
                case -270: {
                    return SVGValueConstants.NUMBER_MINUS_270;
                }
                case -180: {
                    return SVGValueConstants.NUMBER_MINUS_180;
                }
                case -90: {
                    return SVGValueConstants.NUMBER_MINUS_90;
                }
                case 0: {
                    return SVGValueConstants.NUMBER_0;
                }
                case 90: {
                    return SVGValueConstants.NUMBER_90;
                }
                case 180: {
                    return SVGValueConstants.NUMBER_180;
                }
                case 270: {
                    return SVGValueConstants.NUMBER_270;
                }
                case 360: {
                    return SVGValueConstants.NUMBER_360;
                }
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.number", new Object[]{new Integer((int)f)});
    }
}

