/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class URIResolver {
    protected SVGOMDocument document;
    protected String documentURI;
    protected DocumentLoader documentLoader;

    public URIResolver(SVGDocument sVGDocument, DocumentLoader documentLoader) {
        this.document = (SVGOMDocument)sVGDocument;
        this.documentURI = sVGDocument.getURL();
        this.documentLoader = documentLoader;
    }

    public Element getElement(String string) throws MalformedURLException, IOException {
        Node node = this.getNode(string);
        if (node.getNodeType() == 9) {
            throw new Error("Documents not allowed");
        }
        return (Element)node;
    }

    public Node getNode(String string) throws MalformedURLException, IOException {
        if (this.documentURI.equals(string)) {
            return this.document;
        }
        if (string.startsWith(this.documentURI) && string.length() > this.documentURI.length() + 1 && string.charAt(this.documentURI.length()) == '#') {
            string = string.substring(this.documentURI.length());
        }
        if (string.startsWith("#")) {
            return this.document.getElementById(string.substring(1));
        }
        URL uRL = new URL(this.document.getURLObject(), string);
        Document document = this.documentLoader.loadDocument(uRL.toString());
        this.documentLoader.dispose(document);
        String string2 = uRL.getRef();
        if (uRL.getRef() == null) {
            return document;
        }
        return document.getElementById(string2);
    }
}

