/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.SVGViewport;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGSVGElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        Object object;
        float f;
        float f2;
        String string;
        SVGSVGElement sVGSVGElement = (SVGSVGElement)element;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        CanvasGraphicsNode canvasGraphicsNode = new CanvasGraphicsNode();
        canvasGraphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        if (sVGSVGElement.getOwnerSVGElement() != null) {
            string = sVGSVGElement.getAttributeNS(null, "x");
            f2 = 0.0f;
            if (string.length() != 0) {
                f2 = SVGUtilities.svgToUserSpace(sVGSVGElement, "x", string, defaultUnitProcessorContext, (short)2);
            }
            string = sVGSVGElement.getAttributeNS(null, "y");
            f = 0.0f;
            if (string.length() != 0) {
                f = SVGUtilities.svgToUserSpace(sVGSVGElement, "y", string, defaultUnitProcessorContext, (short)1);
            }
        } else {
            f2 = 0.0f;
            f = 0.0f;
        }
        if ((string = sVGSVGElement.getAttributeNS(null, "width")).length() == 0) {
            string = "100%";
        }
        float f3 = SVGUtilities.svgToUserSpace(sVGSVGElement, "width", string, defaultUnitProcessorContext, (short)2);
        string = sVGSVGElement.getAttributeNS(null, "height");
        if (string.length() == 0) {
            string = "100%";
        }
        float f4 = SVGUtilities.svgToUserSpace(sVGSVGElement, "height", string, defaultUnitProcessorContext, (short)1);
        AffineTransform affineTransform = SVGUtilities.getPreserveAspectRatioTransform(sVGSVGElement, f3, f4);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(f2, f));
        Shape shape = null;
        if (sVGSVGElement.getOwnerSVGElement() != null) {
            canvasGraphicsNode.setTransform(affineTransform);
            if (CSSUtilities.convertOverflow(sVGSVGElement)) {
                object = CSSUtilities.convertClip(sVGSVGElement);
                shape = object == null ? new Rectangle2D.Float(f2, f, f3, f4) : new Rectangle2D.Float(f2 + object[3], f + object[0], f3 - object[1], f4 - object[2]);
            }
        } else {
            shape = new Rectangle2D.Float(f2, f, f3, f4);
        }
        if (shape != null) {
            try {
                affineTransform = affineTransform.createInverse();
                shape = affineTransform.createTransformedShape(shape);
                object = bridgeContext.getGraphicsNodeRableFactory();
                GraphicsNodeRable graphicsNodeRable = object.createGraphicsNodeRable(canvasGraphicsNode, bridgeContext.getGraphicsNodeRenderContext());
                canvasGraphicsNode.setClip(new ClipRable8Bit((Filter)graphicsNodeRable, shape));
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        BridgeEventSupport.addDOMListener(bridgeContext, sVGSVGElement);
        bridgeContext.bind(element, canvasGraphicsNode);
        bridgeContext.setViewport(new SVGViewport(sVGSVGElement, defaultUnitProcessorContext));
        return canvasGraphicsNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return true;
    }
}

