/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolylineProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsParser;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    protected void buildShape(BridgeContext bridgeContext, SVGElement sVGElement, ShapeNode shapeNode, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("fill-rule");
        int n = CSSUtilities.rule(cSSPrimitiveValue) == 0 ? 1 : 0;
        String string = sVGElement.getAttributeNS(null, "points");
        if (string.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("polyline.points.required", null));
        }
        PointsParser pointsParser = new PointsParser();
        AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
        aWTPolylineProducer.setWindingRule(n);
        pointsParser.setPointsHandler(aWTPolylineProducer);
        try {
            try {
                pointsParser.parse(new StringReader(string));
            }
            catch (ParseException parseException) {
                throw new IllegalAttributeValueException(Messages.formatMessage("polyline.points.invalid", new Object[]{parseException.getMessage()}), shapeNode);
            }
            Object var13_11 = null;
            shapeNode.setShape(aWTPolylineProducer.getShape());
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            shapeNode.setShape(aWTPolylineProducer.getShape());
            throw throwable;
        }
    }
}

