/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGGradientBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public class SVGLinearGradientBridge
extends SVGGradientBridge
implements PaintBridge {
    public Paint createStrokePaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "stroke-opacity");
    }

    public Paint createFillPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2) {
        return this.createPaint(bridgeContext, graphicsNode, element, element2, "fill-opacity");
    }

    protected Paint createPaint(BridgeContext bridgeContext, GraphicsNode graphicsNode, Element element, Element element2, String string) {
        Object object;
        int n;
        String string2;
        String string3;
        String string4;
        String string5;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element2);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        String string6 = SVGUtilities.getChainableAttributeNS(element2, null, "gradientUnits", documentLoader);
        if (string6.length() == 0) {
            string6 = "objectBoundingBox";
        }
        if ((string5 = SVGUtilities.getChainableAttributeNS(element2, null, "x1", documentLoader)).length() == 0) {
            string5 = "0%";
        }
        if ((string4 = SVGUtilities.getChainableAttributeNS(element2, null, "y1", documentLoader)).length() == 0) {
            string4 = "0%";
        }
        if ((string3 = SVGUtilities.getChainableAttributeNS(element2, null, "x2", documentLoader)).length() == 0) {
            string3 = "100%";
        }
        if ((string2 = SVGUtilities.getChainableAttributeNS(element2, null, "y2", documentLoader)).length() == 0) {
            string2 = "0%";
        }
        try {
            n = SVGUtilities.parseCoordinateSystem(string6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalAttributeValueException(Messages.formatMessage("linearGradient.units.invalid", new Object[]{string6, "gradientUnits"}));
        }
        SVGElement sVGElement = (SVGElement)element;
        Point2D point2D = SVGUtilities.convertGradientPoint(sVGElement, "x1", string5, "y1", string4, n, defaultUnitProcessorContext);
        Point2D point2D2 = SVGUtilities.convertGradientPoint(sVGElement, "x2", string3, "y2", string2, n, defaultUnitProcessorContext);
        String string7 = SVGUtilities.getChainableAttributeNS(element2, null, "spreadMethod", documentLoader);
        if (string7.length() == 0) {
            string7 = "pad";
        }
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = SVGGradientBridge.convertSpreadMethod(string7);
        String string8 = SVGUtilities.getChainableAttributeNS(element2, null, "gradientTransform", documentLoader);
        AffineTransform affineTransform = string8.length() == 0 ? new AffineTransform() : SVGUtilities.convertAffineTransform(string8);
        affineTransform = SVGUtilities.convertAffineTransform(affineTransform, graphicsNode, graphicsNodeRenderContext, n);
        CSSStyleDeclaration cSSStyleDeclaration2 = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration2.getPropertyCSSValue(string);
        float f = CSSUtilities.convertOpacity(cSSPrimitiveValue);
        Vector vector = SVGGradientBridge.extractGradientStops(element2, bridgeContext, f);
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return ((SVGGradientBridge.GradientStop)vector.get((int)0)).stopColor;
        }
        int n2 = vector.size();
        float f2 = 0.0f;
        if (n2 > 0) {
            SVGGradientBridge.GradientStop gradientStop = (SVGGradientBridge.GradientStop)vector.elementAt(0);
            f2 = gradientStop.offset;
        }
        int n3 = 1;
        while (n3 < n2) {
            object = (SVGGradientBridge.GradientStop)vector.elementAt(n3);
            if (((SVGGradientBridge.GradientStop)object).offset < f2) {
                ((SVGGradientBridge.GradientStop)object).offset = f2;
            }
            f2 = ((SVGGradientBridge.GradientStop)object).offset;
            ++n3;
        }
        object = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("color-interpolation");
        MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum = LinearGradientPaint.SRGB;
        if ("linearrgb".equals(object.getStringValue())) {
            colorSpaceEnum = LinearGradientPaint.LINEAR_RGB;
        }
        LinearGradientPaint linearGradientPaint = null;
        if (n2 > 0) {
            Color[] colorArray = new Color[n2];
            float[] fArray = new float[n2];
            int n4 = 0;
            while (n4 < n2) {
                SVGGradientBridge.GradientStop gradientStop = (SVGGradientBridge.GradientStop)vector.elementAt(n4);
                colorArray[n4] = gradientStop.stopColor;
                fArray[n4] = gradientStop.offset;
                ++n4;
            }
            linearGradientPaint = new LinearGradientPaint(point2D, point2D2, fArray, colorArray, cycleMethodEnum, colorSpaceEnum, affineTransform);
        }
        return linearGradientPaint;
    }
}

