/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TurbulenceRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeTurbulenceElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        boolean bl;
        boolean bl2;
        String string;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string2 = element.getAttributeNS(null, "baseFrequency");
        Float[] floatArray = SVGUtilities.buildFloatPair(string2);
        float f = 0.001f;
        if (floatArray[0] != null) {
            f = floatArray[0].floatValue();
        }
        float f2 = f;
        if (floatArray[1] != null) {
            f2 = floatArray[1].floatValue();
        }
        String string3 = element.getAttributeNS(null, "numOctaves");
        int n = 1;
        if (string3.length() != 0) {
            n = SVGUtilities.convertSVGInteger("numOctaves", string3);
        }
        String string4 = element.getAttributeNS(null, "seed");
        int n2 = 0;
        if (string4.length() != 0) {
            n2 = (int)SVGUtilities.convertSVGNumber("seed", string4);
        }
        if ((string = element.getAttributeNS(null, "stitchTiles")).length() == 0) {
            bl2 = false;
        } else if ("stitch".equals(string)) {
            bl2 = true;
        } else if ("noStitch".equals(string)) {
            bl2 = false;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feTurbulence.stitchTiles.invalid", new Object[]{string}));
        }
        String string5 = element.getAttributeNS(null, "type");
        if (string5.length() == 0) {
            bl = false;
        } else if ("fractalNoise".equals(string5)) {
            bl = true;
        } else if ("turbulence".equals(string5)) {
            bl = false;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feTurbulence.type.invalid", new Object[]{string5}));
        }
        Rectangle2D rectangle2D2 = rectangle2D;
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        TurbulenceRable8Bit turbulenceRable8Bit = new TurbulenceRable8Bit(rectangle2D3);
        turbulenceRable8Bit.setBaseFrequencyX(f);
        turbulenceRable8Bit.setBaseFrequencyY(f2);
        turbulenceRable8Bit.setNumOctaves(n);
        turbulenceRable8Bit.setSeed(n2);
        turbulenceRable8Bit.setStitched(bl2);
        turbulenceRable8Bit.setFractalNoise(bl);
        String string6 = element.getAttributeNS(null, "result");
        if (string6 != null && string6.trim().length() > 0) {
            map.put(string6, turbulenceRable8Bit);
        }
        return turbulenceRable8Bit;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

