/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.MorphologyRable8Bit;
import org.apache.batik.ext.awt.image.renderable.PadMode;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeMorphologyElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        boolean bl;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string = element.getAttributeNS(null, "radius");
        Float[] floatArray = SVGUtilities.buildFloatPair(string);
        float f = 0.0f;
        if (floatArray[0] != null) {
            f = floatArray[0].floatValue();
        }
        if (f == 0.0f) {
            return null;
        }
        if (f < 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feMorphology.radiusX.invalid", null));
        }
        float f2 = f;
        if (floatArray[1] != null) {
            f2 = floatArray[1].floatValue();
        }
        if (f2 == 0.0f) {
            return null;
        }
        if (f2 < 0.0f) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feMorphology.radiusY.invalid", null));
        }
        String string2 = element.getAttributeNS(null, "operator");
        if (string2.length() == 0) {
            bl = false;
        } else if ("dilate".equals(string2)) {
            bl = true;
        } else if ("erode".equals(string2)) {
            bl = false;
        } else {
            throw new IllegalAttributeValueException(Messages.formatMessage("feMorphology.operator.invalid", new Object[]{string2}));
        }
        String string3 = element.getAttributeNS(null, "in");
        filter = CSSUtilities.getFilterSource(graphicsNode, string3, bridgeContext, element2, filter, map);
        Filter filter2 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        if (filter == filter2) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter, rectangle2D3, PadMode.ZERO_PAD);
        MorphologyRable8Bit morphologyRable8Bit = new MorphologyRable8Bit(padRable8Bit, f, f2, bl);
        String string4 = element.getAttributeNS(null, "result");
        if (string4 != null && string4.trim().length() > 0) {
            map.put(string4, morphologyRable8Bit);
        }
        return morphologyRable8Bit;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

