/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.text.PlainDocument;
import org.apache.batik.apps.svgviewer.StatusBar;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.parser.DefaultFragmentIdentifierHandler;
import org.apache.batik.parser.FragmentIdentifierParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.DocumentEvent;
import org.apache.batik.util.DocumentListener;
import org.apache.batik.util.DocumentLoadRunnable;
import org.apache.batik.util.DocumentLoadingEvent;
import org.apache.batik.util.DocumentPropertyEvent;
import org.apache.batik.util.SVGFileFilter;
import org.apache.batik.util.gui.DOMViewer;
import org.apache.batik.util.gui.LanguageChangeHandler;
import org.apache.batik.util.gui.LanguageDialog;
import org.apache.batik.util.gui.LocationBar;
import org.apache.batik.util.gui.MemoryMonitor;
import org.apache.batik.util.gui.URIChooser;
import org.apache.batik.util.gui.UserStyleDialog;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.MenuFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.apache.batik.util.gui.resource.ToolBarFactory;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGAElement;

public class ViewerFrame
extends JFrame
implements ActionMap,
UserAgent,
LanguageChangeHandler,
UserStyleDialog.ChangeHandler,
JSVGCanvas.ZoomHandler,
DocumentListener {
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OPEN_PAGE_ACTION = "OpenPageAction";
    public static final String NEW_WINDOW_ACTION = "NewWindowAction";
    public static final String EXPORT_PNG_ACTION = "ExportPNGAction";
    public static final String EXPORT_JPG_ACTION = "ExportJPGAction";
    public static final String RELOAD_ACTION = "ReloadAction";
    public static final String BACK_ACTION = "BackAction";
    public static final String FORWARD_ACTION = "ForwardAction";
    public static final String CLOSE_ACTION = "CloseAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String FULLSCREEN_ACTION = "FullscreenAction";
    public static final String SOURCE_ACTION = "SourceAction";
    public static final String DESCRIPTION_ACTION = "DescriptionAction";
    public static final String TREE_ACTION = "TreeAction";
    public static final String THUMBNAIL_ACTION = "ThumbnailAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String FIXED_SIZE_ACTION = "FixedSizeAction";
    public static final String PROG_PAINT_ACTION = "ProgressivePaintAction";
    public static final String LANGUAGE_ACTION = "LanguageAction";
    public static final String USER_STYLE_ACTION = "UserStyleAction";
    public static final String MONITOR_ACTION = "MonitorAction";
    public static final String ABOUT_ACTION = "AboutAction";
    public static final String PRINT_ACTION = "PrintAction";
    protected static final Cursor DEFAULT_CURSOR = new Cursor(0);
    protected static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final String RESOURCES = "org.apache.batik.apps.svgviewer.resources.GUI";
    protected static JFrame memoryMonitor;
    protected static JFrame aboutFrame;
    protected static ResourceBundle bundle;
    protected static ResourceManager resources;
    protected static char[] buffer;
    protected Application application;
    protected LocationBar locationBar;
    protected String uri;
    protected String currentPath = ".";
    protected String currentExportPath = ".";
    protected URIChooser uriChooser;
    protected JPanel panel;
    protected StatusBar statusBar;
    protected JSVGCanvas canvas;
    protected Thread thread;
    protected DOMViewer domViewer = new DOMViewer();
    private LanguageDialog languageDialog;
    protected UserStyleDialog userStyleDialog;
    protected JFrame thumbnailFrame;
    protected ReloadAction reloadAction = new ReloadAction();
    protected BackAction backAction = new BackAction();
    protected ForwardAction forwardAction = new ForwardAction();
    protected StopAction stopAction = new StopAction();
    protected String description = "";
    protected boolean fixedSize;
    protected boolean progressivePaintEnabled;
    private AWTEventDispatcher eventDispatcher;
    protected String userLanguages = "en";
    protected String userStyleSheetURI;
    protected List loadedDocuments = new ArrayList();
    protected int loadedDocument = -1;
    protected int loadedDocumentsCount;
    private SVGDocumentFactory df;
    protected Map listeners = new HashMap();
    private JWindow fullscreenWindow;
    private boolean isFullscreen = false;

    public ViewerFrame(Application application) {
        Object object;
        this.application = application;
        if (!Locale.getDefault().getLanguage().equals(this.userLanguages)) {
            this.userLanguages = Locale.getDefault().getLanguage() + "," + this.userLanguages;
        }
        this.setTitle(resources.getString("Frame.title"));
        ((Component)this).setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        URL uRL = this.getClass().getResource(resources.getString("Frame.icon"));
        ((Frame)this).setIconImage(new ImageIcon(uRL).getImage());
        this.df = new SAXSVGDocumentFactory(this.application.getXMLParserClassName());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ViewerFrame.this.close();
            }
        });
        this.uriChooser = new URIChooser(this, (Action)new URIChooserOKAction());
        this.uriChooser.setFileFilter(new SVGFileFilter());
        this.canvas = new JSVGCanvas(this);
        this.eventDispatcher = new AWTEventDispatcher(this.canvas.getRendererFactory().getRenderContext());
        this.listeners.put(OPEN_ACTION, new OpenAction());
        this.listeners.put(OPEN_PAGE_ACTION, new OpenPageAction());
        this.listeners.put(NEW_WINDOW_ACTION, new NewWindowAction());
        this.listeners.put(EXPORT_PNG_ACTION, new ExportPNGAction());
        this.listeners.put(EXPORT_JPG_ACTION, new ExportJPGAction());
        this.listeners.put(RELOAD_ACTION, this.reloadAction);
        this.listeners.put(BACK_ACTION, this.backAction);
        this.listeners.put(FORWARD_ACTION, this.forwardAction);
        this.listeners.put(CLOSE_ACTION, this.application.createCloseAction(this));
        this.listeners.put(EXIT_ACTION, this.application.createExitAction());
        this.listeners.put(FULLSCREEN_ACTION, new FullscreenAction());
        this.listeners.put(SOURCE_ACTION, new SourceAction());
        this.listeners.put(DESCRIPTION_ACTION, new DescriptionAction());
        this.listeners.put(TREE_ACTION, new TreeAction());
        this.listeners.put(THUMBNAIL_ACTION, new ThumbnailAction());
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(PROG_PAINT_ACTION, new ProgressivePaintAction());
        this.listeners.put(FIXED_SIZE_ACTION, new FixedSizeAction());
        this.listeners.put(LANGUAGE_ACTION, new LanguageAction());
        this.listeners.put(USER_STYLE_ACTION, new UserStyleAction());
        this.listeners.put(MONITOR_ACTION, new MonitorAction());
        this.listeners.put(ABOUT_ACTION, new AboutAction());
        this.listeners.put(PRINT_ACTION, new PrintAction());
        JPanel jPanel = null;
        try {
            object = new MenuFactory(bundle, this);
            this.setJMenuBar(((MenuFactory)object).createJMenuBar("MenuBar"));
            jPanel = new JPanel(new BorderLayout());
            ToolBarFactory toolBarFactory = new ToolBarFactory(bundle, this);
            JToolBar jToolBar = toolBarFactory.createJToolBar("ToolBar");
            jToolBar.setFloatable(false);
            this.getContentPane().add((Component)jPanel, "North");
            jPanel.add((Component)jToolBar, "North");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.exit(0);
        }
        this.locationBar = new LocationBar();
        this.locationBar.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 1));
        this.locationBar.addActionListener(new LocationBarAction());
        jPanel.add((Component)this.locationBar, "South");
        jPanel.add((Component)new JSeparator(), "Center");
        this.panel = new JPanel(new BorderLayout());
        this.panel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.panel, "Center");
        jPanel = new JPanel(new BorderLayout());
        this.panel.add((Component)jPanel, "Center");
        this.statusBar = new StatusBar();
        this.getContentPane().add((Component)this.statusBar, "South");
        object = new Timer(15000, new InitLanguageDialog());
        ((Timer)object).setRepeats(false);
        ((Timer)object).start();
        object = null;
        this.userStyleDialog = new UserStyleDialog(this);
        this.userStyleDialog.setChangeHandler(this);
        this.panel.add((Component)this.canvas, "Center");
        this.panel.revalidate();
        this.panel.repaint();
        this.canvas.setZoomHandler(this);
        this.canvas.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ViewerFrame.this.statusBar.setXPosition(mouseEvent.getX());
                ViewerFrame.this.statusBar.setYPosition(mouseEvent.getY());
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                Dimension dimension = ViewerFrame.this.canvas.getSize();
                ViewerFrame.this.statusBar.setWidth(dimension.width);
                ViewerFrame.this.statusBar.setHeight(dimension.height);
            }
        });
        this.canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = ViewerFrame.this.canvas.getSize();
                ViewerFrame.this.statusBar.setWidth(dimension.width);
                ViewerFrame.this.statusBar.setHeight(dimension.height);
            }
        });
    }

    protected LanguageDialog getLanguageDialog() {
        if (this.languageDialog == null) {
            this.languageDialog = new LanguageDialog(this);
            this.languageDialog.setLanguageChangeHandler(this);
        }
        return this.languageDialog;
    }

    public void setFixedSize(boolean bl) {
        this.fixedSize = bl;
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public Thread getLoadingThread() {
        return this.thread;
    }

    public void languageChanged(String string) {
        this.userLanguages = string;
    }

    public void userStyleSheetURIChanged(String string) {
        this.userStyleSheetURI = string;
    }

    public void zoomChanged(float f) {
        this.statusBar.setZoom(f);
    }

    public Dimension2D getViewportSize() {
        return this.canvas.getSize();
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void displayError(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane jOptionPane = new JOptionPane(string, 0);
                JDialog jDialog = jOptionPane.createDialog(ViewerFrame.this, "ERROR");
                jDialog.show();
            }
        };
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public void displayError(Exception exception) {
        this.displayError(exception.getMessage());
    }

    public void displayMessage(String string) {
        this.statusBar.setMainMessage(string);
    }

    public float getPixelToMM() {
        return 0.26458332f;
    }

    public String getLanguages() {
        return this.userLanguages;
    }

    public String getUserStyleSheetURI() {
        return this.userStyleSheetURI;
    }

    public void openLink(SVGAElement sVGAElement) {
        this.application.openLink(this, sVGAElement);
    }

    public void setSVGCursor(Cursor cursor) {
        this.canvas.setCursor(cursor);
    }

    public synchronized void runThread(Thread thread) {
        this.stopAction.update(true);
        this.reloadAction.update(false);
        this.thread = thread;
        this.thread.start();
    }

    public String getXMLParserClassName() {
        return this.application.getXMLParserClassName();
    }

    public AffineTransform getTransform() {
        return this.canvas.getTransform();
    }

    public Point getClientAreaLocationOnScreen() {
        return this.canvas.getLocationOnScreen();
    }

    public void loadDocument(String string) {
        String string2 = this.uri;
        this.uri = string;
        File file = new File(this.uri);
        if (file.exists()) {
            this.uri = file.isDirectory() ? null : "file:" + this.uri;
        }
        if (this.uri != null) {
            Object object;
            if (string2 != null) {
                object = null;
                try {
                    object = new URL(string2);
                    if (((URL)object).sameFile(new URL(this.uri))) {
                        this.manageFragmentIdentifier();
                        return;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            ++this.loadedDocument;
            if (this.loadedDocument == this.loadedDocuments.size()) {
                this.loadedDocuments.add(this.uri);
            } else {
                object = this.loadedDocuments.get(this.loadedDocument);
                if (!object.equals(this.uri)) {
                    this.loadedDocumentsCount = this.loadedDocument + 1;
                }
                this.loadedDocuments.set(this.loadedDocument, this.uri);
            }
            if (this.loadedDocumentsCount == this.loadedDocument) {
                ++this.loadedDocumentsCount;
            }
            this.backAction.update();
            this.forwardAction.update();
            this.locationBar.setText(this.uri);
            object = DocumentLoadRunnable.createLoaderThread(this.uri, this, this.df);
            this.runThread((Thread)object);
        }
    }

    protected void manageFragmentIdentifier() {
        URL uRL = null;
        try {
            uRL = new URL(this.uri);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException.getMessage());
        }
        String string = uRL.getRef();
        if (string == null) {
            this.canvas.setTransform(new AffineTransform());
        } else {
            FragmentIdentifierParser fragmentIdentifierParser = new FragmentIdentifierParser();
            FragmentIdentifierHandler fragmentIdentifierHandler = new FragmentIdentifierHandler();
            fragmentIdentifierParser.setFragmentIdentifierHandler(fragmentIdentifierHandler);
            try {
                fragmentIdentifierParser.parse(new StringReader(string));
                this.canvas.setViewBox(fragmentIdentifierHandler.x, fragmentIdentifierHandler.y, fragmentIdentifierHandler.width, fragmentIdentifierHandler.height);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println(exception.getMessage());
            }
        }
    }

    public Action getAction(String string) throws MissingListenerException {
        Action action = (Action)this.listeners.get(string);
        if (action == null) {
            action = this.canvas.getAction(string);
        }
        return action;
    }

    public void close() {
        if (this.application.closeFrame(this)) {
            ((Component)this).setVisible(false);
        }
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        if (documentEvent.classid == DocumentEvent.LOADING) {
            this.processDocumentLoadingEvent((DocumentLoadingEvent)documentEvent);
        } else if (documentEvent.classid == DocumentEvent.PROPERTY) {
            this.processDocumentPropertyEvent((DocumentPropertyEvent)documentEvent);
        }
    }

    public void processDocumentLoadingEvent(DocumentLoadingEvent documentLoadingEvent) {
        switch (documentLoadingEvent.type) {
            case 1: {
                this.setCursor(WAIT_CURSOR);
                this.setSVGCursor(WAIT_CURSOR);
                this.canvas.setSVGDocument(null);
                this.reloadAction.update(false);
                this.stopAction.update(true);
                this.statusBar.setMainMessage(resources.getString("Document.loading"));
                break;
            }
            case 2: {
                DefaultSVGContext defaultSVGContext = new DefaultSVGContext(){

                    public float getPixelToMM() {
                        return ViewerFrame.this.getPixelToMM();
                    }

                    public float getViewportWidth() {
                        return (float)ViewerFrame.this.canvas.getSize().getWidth();
                    }

                    public float getViewportHeight() {
                        return (float)ViewerFrame.this.canvas.getSize().getHeight();
                    }
                };
                SVGOMDocument sVGOMDocument = (SVGOMDocument)documentLoadingEvent.getValue();
                defaultSVGContext.setUserStyleSheetURI(this.userStyleSheetURI);
                sVGOMDocument.setSVGContext(defaultSVGContext);
                this.domViewer.setDocument(sVGOMDocument, (ViewCSS)((Object)sVGOMDocument.getDocumentElement()));
                this.statusBar.setMainMessage(resources.getString("Document.creating"));
                break;
            }
            case 15: {
                SVGOMDocument sVGOMDocument = (SVGOMDocument)documentLoadingEvent.getValue();
                this.canvas.setSVGDocument(sVGOMDocument);
                this.setCursor(DEFAULT_CURSOR);
                this.stopAction.update(false);
                this.reloadAction.update(true);
                this.statusBar.setMainMessage("");
                this.statusBar.setMessage(resources.getString("Document.done"));
                break;
            }
            case 254: {
                this.setCursor(DEFAULT_CURSOR);
                this.stopAction.update(false);
                this.reloadAction.update(true);
                this.statusBar.setMainMessage("");
                this.statusBar.setMessage(resources.getString("Document.cancelled"));
                break;
            }
            case 255: {
                this.setCursor(DEFAULT_CURSOR);
                this.stopAction.update(false);
                this.reloadAction.update(true);
                this.statusBar.setMainMessage("");
                this.statusBar.setMessage(resources.getString("Document.failed"));
                this.displayError(documentLoadingEvent.getException());
            }
        }
    }

    public void processDocumentPropertyEvent(DocumentPropertyEvent documentPropertyEvent) {
        switch (documentPropertyEvent.type) {
            case 1: {
                String string = (String)documentPropertyEvent.getValue();
                if (string.equals("")) {
                    this.setTitle(resources.getString("Frame.title") + ": " + resources.getString("Frame.no_title"));
                    break;
                }
                this.setTitle(resources.getString("Frame.title") + ": " + string);
                break;
            }
            case 2: {
                Dimension dimension = (Dimension)documentPropertyEvent.getValue();
                if (this.canvas.getSize().equals(dimension)) break;
                this.canvas.setPreferredSize(dimension);
                this.panel.invalidate();
                if (this.fixedSize) break;
                this.pack();
                break;
            }
            case 15: {
                String string = (String)documentPropertyEvent.getValue();
                if (string.equals("")) {
                    string = resources.getString("Description.no_description");
                }
                this.description = string;
            }
        }
    }

    static {
        bundle = ResourceBundle.getBundle(RESOURCES, Locale.getDefault());
        resources = new ResourceManager(bundle);
        buffer = new char[4096];
    }

    public class LocationBarAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ViewerFrame.this.locationBar.getText().trim();
            if (!string.equals("") && !string.equals(ViewerFrame.this.uri)) {
                ViewerFrame.this.uri = string;
                File file = new File(ViewerFrame.this.uri);
                if (file.exists()) {
                    ViewerFrame.this.uri = file.isDirectory() ? null : "file:" + ViewerFrame.this.uri;
                }
                if (ViewerFrame.this.uri != null) {
                    ViewerFrame.this.locationBar.setText(ViewerFrame.this.uri);
                    ViewerFrame.this.locationBar.addToHistory(ViewerFrame.this.uri);
                    Thread thread = DocumentLoadRunnable.createLoaderThread(ViewerFrame.this.uri, ViewerFrame.this, ViewerFrame.this.df);
                    ViewerFrame.this.runThread(thread);
                }
            }
        }
    }

    public class AboutAction
    extends AbstractAction
    implements DocumentListener {
        JSVGCanvas canvas;

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            Serializable serializable2;
            if (aboutFrame == null) {
                aboutFrame = new JFrame(resources.getString("About.title"));
                ((Component)aboutFrame).setSize(resources.getInteger("About.width"), resources.getInteger("About.height"));
                serializable2 = new JPanel(new BorderLayout());
                aboutFrame.getContentPane().add((Component)serializable2);
                ((JComponent)serializable2).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("About.border_title"), 2, 0), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                serializable = new JPanel(new FlowLayout(2));
                ButtonFactory buttonFactory = new ButtonFactory(bundle, null);
                JButton jButton = buttonFactory.createJButton("AboutCloseButton");
                ((Container)serializable).add(jButton);
                jButton.addActionListener(new AbstractAction(this){
                    private final /* synthetic */ AboutAction this$1;
                    {
                        this.this$1 = aboutAction;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Component)aboutFrame).setVisible(false);
                    }
                });
                aboutFrame.getContentPane().add((Component)serializable, "South");
                this.canvas = new JSVGCanvas(ViewerFrame.this);
                this.canvas.setBorder(BorderFactory.createLoweredBevelBorder());
                ((Container)serializable2).add(this.canvas);
                String string = this.getClass().getResource("resources/authors.svg").toString();
                Thread thread = DocumentLoadRunnable.createLoaderThread(string, this, ViewerFrame.this.df);
                thread.start();
            }
            serializable2 = ViewerFrame.this.getBounds();
            serializable = aboutFrame.getSize();
            ((Component)aboutFrame).setLocation(((Rectangle)serializable2).x + (((Rectangle)serializable2).width - ((Dimension)serializable).width) / 2, ((Rectangle)serializable2).y + (((Rectangle)serializable2).height - ((Dimension)serializable).height) / 2);
            aboutFrame.show();
        }

        public void processDocumentEvent(DocumentEvent documentEvent) {
            if (documentEvent.classid == DocumentEvent.LOADING) {
                if (documentEvent.type == 15) {
                    DefaultSVGContext defaultSVGContext = new DefaultSVGContext(this){
                        private final /* synthetic */ AboutAction this$1;
                        {
                            this.this$1 = aboutAction;
                        }

                        public float getPixelToMM() {
                            return AboutAction.access$700(this.this$1).getPixelToMM();
                        }

                        public float getViewportWidth() {
                            return (float)this.this$1.canvas.getSize().getWidth();
                        }

                        public float getViewportHeight() {
                            return (float)this.this$1.canvas.getSize().getHeight();
                        }
                    };
                    SVGOMDocument sVGOMDocument = (SVGOMDocument)documentEvent.getValue();
                    sVGOMDocument.setSVGContext(defaultSVGContext);
                    this.canvas.setSVGDocument(sVGOMDocument);
                }
            } else if (documentEvent.classid == DocumentEvent.PROPERTY) {
                // empty if block
            }
        }

        static /* synthetic */ ViewerFrame access$700(AboutAction aboutAction) {
            return aboutAction.ViewerFrame.this;
        }
    }

    public class MonitorAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (memoryMonitor == null) {
                memoryMonitor = new MemoryMonitor();
            }
            memoryMonitor.show();
        }
    }

    public class UserStyleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = ViewerFrame.this.getBounds();
            Dimension dimension = ViewerFrame.this.userStyleDialog.getSize();
            ((Component)ViewerFrame.this.userStyleDialog).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            ViewerFrame.this.userStyleDialog.pack();
            ViewerFrame.this.userStyleDialog.show();
        }
    }

    public class LanguageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = ViewerFrame.this.getBounds();
            LanguageDialog languageDialog = ViewerFrame.this.getLanguageDialog();
            Dimension dimension = languageDialog.getSize();
            ((Component)languageDialog).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            languageDialog.setLanguages(ViewerFrame.this.userLanguages);
            languageDialog.show();
        }
    }

    public class ProgressivePaintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.progressivePaintEnabled = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
            ViewerFrame.this.canvas.setProgressiveRenderingEnabled(ViewerFrame.this.progressivePaintEnabled);
        }
    }

    public class FixedSizeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.fixedSize = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
        }
    }

    public class PrintAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(new Printable(this){
                private final /* synthetic */ PrintAction this$1;
                {
                    this.this$1 = printAction;
                }

                public int print(Graphics graphics, PageFormat pageFormat, int n) {
                    if (n > 0) {
                        return 1;
                    }
                    PrintAction.access$600((PrintAction)this.this$1).canvas.paintComponent(graphics);
                    return 0;
                }
            });
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ ViewerFrame access$600(PrintAction printAction) {
            return printAction.ViewerFrame.this;
        }
    }

    public class StopAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewerFrame.this.thread.isAlive()) {
                ViewerFrame.this.thread.interrupt();
            }
            this.update(false);
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ThumbnailAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (ViewerFrame.this.thumbnailFrame == null) {
                ViewerFrame.this.thumbnailFrame = new JFrame(resources.getString("Thumbnail.title"));
                ((Component)ViewerFrame.this.thumbnailFrame).setSize(resources.getInteger("Thumbnail.width"), resources.getInteger("Thumbnail.height"));
                ViewerFrame.this.thumbnailFrame.getContentPane().add(ViewerFrame.this.canvas.getThumbnail());
                serializable = this.getClass().getResource(resources.getString("Frame.icon"));
                ((Frame)ViewerFrame.this.thumbnailFrame).setIconImage(new ImageIcon((URL)serializable).getImage());
            }
            serializable = ViewerFrame.this.getBounds();
            Dimension dimension = ViewerFrame.this.thumbnailFrame.getSize();
            ((Component)ViewerFrame.this.thumbnailFrame).setLocation(serializable.x + (serializable.width - dimension.width) / 2, serializable.y + (serializable.height - dimension.height) / 2);
            ViewerFrame.this.thumbnailFrame.show();
        }
    }

    public class TreeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = ViewerFrame.this.getBounds();
            Dimension dimension = ViewerFrame.this.domViewer.getSize();
            ((Component)ViewerFrame.this.domViewer).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            ViewerFrame.this.domViewer.show();
        }
    }

    public class DescriptionAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewerFrame.this.description == null) {
                return;
            }
            JFrame jFrame = new JFrame(ViewerFrame.this.uri);
            ((Component)jFrame).setSize(resources.getInteger("Description.width"), resources.getInteger("Description.height"));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setFont(new Font("monospaced", 0, 10));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jTextArea.setText(ViewerFrame.this.description);
            jTextArea.setEditable(false);
            jFrame.show();
        }
    }

    protected class SourceAction
    extends AbstractAction {
        protected SourceAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewerFrame.this.uri == null) {
                return;
            }
            JFrame jFrame = new JFrame(ViewerFrame.this.uri);
            ((Component)jFrame).setSize(resources.getInteger("Source.width"), resources.getInteger("Source.height"));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setFont(new Font("monospaced", 0, 11));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            PlainDocument plainDocument = new PlainDocument();
            InputStream inputStream = null;
            try {
                URL uRL = new URL(ViewerFrame.this.uri);
                inputStream = uRL.openStream();
                try {
                    inputStream = new GZIPInputStream(inputStream);
                }
                catch (IOException iOException) {
                    inputStream.close();
                    inputStream = uRL.openStream();
                }
                try {
                    int n;
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "Unicode");
                    while ((n = ((Reader)inputStreamReader).read(buffer, 0, buffer.length)) != -1) {
                        plainDocument.insertString(plainDocument.getLength(), new String(buffer, 0, n), null);
                    }
                }
                catch (CharConversionException charConversionException) {
                    plainDocument = new PlainDocument();
                    inputStream = uRL.openStream();
                    try {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    catch (IOException iOException) {
                        inputStream.close();
                        inputStream = uRL.openStream();
                    }
                    try {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                        while ((n = ((Reader)inputStreamReader).read(buffer, 0, buffer.length)) != -1) {
                            plainDocument.insertString(plainDocument.getLength(), new String(buffer, 0, n), null);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(exception.toString());
                    }
                }
                jTextArea.setDocument(plainDocument);
                jTextArea.setEditable(false);
                jFrame.show();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
    }

    protected class FullscreenAction
    extends AbstractAction
    implements KeyListener {
        protected FullscreenAction() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if ((keyEvent.getModifiers() & 2) != 0) {
                if (keyEvent.getKeyCode() == 88) {
                    ViewerFrame.this.fullscreenWindow.dispose();
                    ViewerFrame.this.fullscreenWindow.getContentPane().remove(ViewerFrame.this.canvas);
                    ViewerFrame.this.panel.add((Component)ViewerFrame.this.canvas, "Center");
                    ViewerFrame.this.show();
                    ViewerFrame.this.isFullscreen = false;
                } else if (keyEvent.getKeyCode() == 49) {
                    ViewerFrame.this.canvas.getAction("UnzoomAction").actionPerformed(null);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewerFrame.this.fullscreenWindow == null) {
                ViewerFrame.this.fullscreenWindow = new JWindow();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                ((Component)ViewerFrame.this.fullscreenWindow).setSize(toolkit.getScreenSize());
                ViewerFrame.this.fullscreenWindow.addKeyListener(this);
            }
            ViewerFrame.this.panel.remove(ViewerFrame.this.canvas);
            ViewerFrame.this.fullscreenWindow.getContentPane().add((Component)ViewerFrame.this.canvas, "Center");
            ViewerFrame.this.dispose();
            ViewerFrame.this.fullscreenWindow.show();
            ViewerFrame.this.isFullscreen = true;
        }
    }

    public class ForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.loadDocument((String)ViewerFrame.this.loadedDocuments.get(ViewerFrame.this.loadedDocument + 1));
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = ViewerFrame.this.loadedDocument < ViewerFrame.this.loadedDocumentsCount - 1;
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class BackAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.loadedDocument -= 2;
            ViewerFrame.this.loadDocument((String)ViewerFrame.this.loadedDocuments.get(ViewerFrame.this.loadedDocument + 1));
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(false);
        }

        protected void update() {
            boolean bl = ViewerFrame.this.loadedDocument > 0;
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ReloadAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        public void actionPerformed(ActionEvent actionEvent) {
            if (ViewerFrame.this.uri != null) {
                Thread thread = DocumentLoadRunnable.createLoaderThread(ViewerFrame.this.uri, ViewerFrame.this, ViewerFrame.this.df);
                ViewerFrame.this.runThread(thread);
            }
        }

        public void addJComponent(JComponent jComponent) {
            this.components.add(jComponent);
            jComponent.setEnabled(true);
        }

        protected void update(boolean bl) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                ((JComponent)iterator.next()).setEnabled(bl);
            }
        }
    }

    public class ExportJPGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(ViewerFrame.this.currentExportPath);
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            int n = jFileChooser.showSaveDialog(ViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = ViewerFrame.this.canvas.getBuffer();
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                JPEGTranscoder jPEGTranscoder = new JPEGTranscoder();
                jPEGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
                BufferedImage bufferedImage2 = ((ImageTranscoder)jPEGTranscoder).createImage(n2, n3);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage(bufferedImage, null, 0, 0);
                new Thread(this, file, jPEGTranscoder, bufferedImage2){
                    private final /* synthetic */ File val$f;
                    private final /* synthetic */ ImageTranscoder val$trans;
                    private final /* synthetic */ BufferedImage val$img;
                    private final /* synthetic */ ExportJPGAction this$1;
                    {
                        this.this$1 = exportJPGAction;
                        this.val$f = file;
                        this.val$trans = imageTranscoder;
                        this.val$img = bufferedImage;
                    }

                    public void run() {
                        try {
                            ExportJPGAction.access$200((ExportJPGAction)this.this$1).currentExportPath = this.val$f.getCanonicalPath();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                            this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                            ((OutputStream)bufferedOutputStream).flush();
                            ((OutputStream)bufferedOutputStream).close();
                            ExportJPGAction.access$200((ExportJPGAction)this.this$1).statusBar.setMessage(resources.getString("Document.export"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }

        static /* synthetic */ ViewerFrame access$200(ExportJPGAction exportJPGAction) {
            return exportJPGAction.ViewerFrame.this;
        }
    }

    public class ExportPNGAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(ViewerFrame.this.currentExportPath);
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            int n = jFileChooser.showSaveDialog(ViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                BufferedImage bufferedImage = ViewerFrame.this.canvas.getBuffer();
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                PNGTranscoder pNGTranscoder = new PNGTranscoder();
                pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
                BufferedImage bufferedImage2 = ((ImageTranscoder)pNGTranscoder).createImage(n2, n3);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage(bufferedImage, null, 0, 0);
                new Thread(this, file, pNGTranscoder, bufferedImage2){
                    private final /* synthetic */ File val$f;
                    private final /* synthetic */ ImageTranscoder val$trans;
                    private final /* synthetic */ BufferedImage val$img;
                    private final /* synthetic */ ExportPNGAction this$1;
                    {
                        this.this$1 = exportPNGAction;
                        this.val$f = file;
                        this.val$trans = imageTranscoder;
                        this.val$img = bufferedImage;
                    }

                    public void run() {
                        try {
                            ExportPNGAction.access$100((ExportPNGAction)this.this$1).currentExportPath = this.val$f.getCanonicalPath();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.val$f));
                            this.val$trans.writeImage(this.val$img, new TranscoderOutput(bufferedOutputStream));
                            ((OutputStream)bufferedOutputStream).flush();
                            ((OutputStream)bufferedOutputStream).close();
                            ExportPNGAction.access$100((ExportPNGAction)this.this$1).statusBar.setMessage(resources.getString("Document.export"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }

        static /* synthetic */ ViewerFrame access$100(ExportPNGAction exportPNGAction) {
            return exportPNGAction.ViewerFrame.this;
        }
    }

    public class NewWindowAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.application.createAndShowViewerFrame();
        }
    }

    public class OpenPageAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.uriChooser.pack();
            Rectangle rectangle = ViewerFrame.this.getBounds();
            Dimension dimension = ViewerFrame.this.uriChooser.getSize();
            ((Component)ViewerFrame.this.uriChooser).setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
            ViewerFrame.this.uriChooser.show();
        }
    }

    public class OpenAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(ViewerFrame.this.currentPath);
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setFileFilter(new SVGFileFilter());
            int n = jFileChooser.showOpenDialog(ViewerFrame.this);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    ViewerFrame.this.currentPath = file.getCanonicalPath();
                    ViewerFrame.this.loadDocument(ViewerFrame.this.currentPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public class URIChooserOKAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ViewerFrame.this.loadDocument(ViewerFrame.this.uriChooser.getText());
        }
    }

    public static interface Application {
        public void createAndShowViewerFrame();

        public Action createCloseAction(ViewerFrame var1);

        public Action createExitAction();

        public String getXMLParserClassName();

        public boolean closeFrame(ViewerFrame var1);

        public void openLink(ViewerFrame var1, SVGAElement var2);
    }

    protected static class FragmentIdentifierHandler
    extends DefaultFragmentIdentifierHandler {
        float x;
        float y;
        float width;
        float height;

        protected FragmentIdentifierHandler() {
        }

        public void viewBox(float f, float f2, float f3, float f4) throws ParseException {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }
    }

    private static class InitLanguageDialog
    implements ActionListener {
        private InitLanguageDialog() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(new Runnable(this){
                private final /* synthetic */ InitLanguageDialog this$0;
                {
                    this.this$0 = initLanguageDialog;
                }

                public void run() {
                    LanguageDialog.Panel.initCountryIcons();
                }
            });
            thread.setPriority(1);
            thread.start();
            ((Timer)actionEvent.getSource()).stop();
        }
    }
}

