/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgviewer;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.apache.batik.util.gui.resource.ResourceManager;

public class StatusBar
extends JPanel {
    protected static final String RESOURCES = "org.apache.batik.apps.svgviewer.resources.StatusBarMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgviewer.resources.StatusBarMessages", Locale.getDefault());
    protected static ResourceManager rManager = new ResourceManager(bundle);
    protected JLabel xPosition;
    protected JLabel yPosition;
    protected JLabel zoom;
    protected MessageArea message;
    protected String mainMessage;

    public StatusBar() {
        super(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.add("West", jPanel);
        this.xPosition = new JLabel();
        BevelBorder bevelBorder = new BevelBorder(1, this.getBackground().brighter().brighter(), this.getBackground(), this.getBackground().darker().darker(), this.getBackground());
        this.xPosition.setBorder(bevelBorder);
        this.xPosition.setPreferredSize(new Dimension(70, 16));
        jPanel.add("West", this.xPosition);
        this.yPosition = new JLabel();
        this.yPosition.setBorder(bevelBorder);
        this.yPosition.setPreferredSize(new Dimension(70, 16));
        jPanel.add("Center", this.yPosition);
        this.zoom = new JLabel();
        this.zoom.setBorder(bevelBorder);
        this.zoom.setPreferredSize(new Dimension(70, 16));
        jPanel.add("East", this.zoom);
        jPanel = new JPanel(new BorderLayout(0, 0));
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(2);
        hashMap.put(TextAttribute.FAMILY, "default");
        hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        this.message = new MessageArea(hashMap);
        this.message.setBorder(bevelBorder);
        jPanel.add(this.message);
        this.add(jPanel);
        this.setMainMessage(rManager.getString("Panel.default_message"));
    }

    public void setXPosition(int n) {
        this.xPosition.setText("x: " + n);
    }

    public void setWidth(int n) {
        this.xPosition.setText(rManager.getString("Position.width_letters") + " " + n);
    }

    public void setYPosition(int n) {
        this.yPosition.setText("y: " + n);
    }

    public void setHeight(int n) {
        this.yPosition.setText(rManager.getString("Position.height_letters") + " " + n);
    }

    public void setZoom(float f) {
        float f2 = f = f > 0.0f ? f : -f;
        if (f == 1.0f) {
            this.zoom.setText("1:1");
        } else if (f >= 1.0f) {
            String string = Float.toString(f);
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            this.zoom.setText("1:" + string);
        } else {
            String string = Float.toString(1.0f / f);
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            this.zoom.setText(string + ":1");
        }
    }

    public void setMessage(String string) {
        this.mainMessage = string;
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
        new DisplayThread().start();
    }

    public void setMainMessage(String string) {
        this.mainMessage = string;
        this.mainMessage = string;
        this.message.setText(this.mainMessage);
        this.setPreferredSize(new Dimension(0, this.getPreferredSize().height));
    }

    public class MessageArea
    extends JLabel {
        String text = "";
        TextLayout layout;
        FontRenderContext frc;
        Map textAttMap;
        Font font;

        public MessageArea(Map map) {
            this.textAttMap = map;
            this.font = (Font)UIManager.get("Label.font");
            this.frc = new FontRenderContext(new AffineTransform(), true, true);
        }

        public void setText(String string) {
            int n;
            this.text = string;
            this.layout = string.length() > 0 ? ((n = this.font.canDisplayUpTo(this.text)) == this.text.length() || n == -1 ? new TextLayout(this.text, this.font, this.frc) : new TextLayout(this.text, this.textAttMap, this.frc)) : null;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            graphics.setColor(this.getForeground());
            if (this.layout != null) {
                this.layout.draw((Graphics2D)graphics, (float)this.getX() + (float)insets.left + 2.0f, this.getY() + this.getHeight() - insets.bottom - 2);
            }
        }
    }

    protected class DisplayThread
    extends Thread {
        public DisplayThread() {
            this.setPriority(1);
        }

        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            StatusBar.this.message.setText(StatusBar.this.mainMessage);
        }
    }
}

