/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.applet;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import javax.swing.JApplet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.dom.svg.DefaultSVGContext;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.util.DocumentEvent;
import org.apache.batik.util.DocumentListener;
import org.apache.batik.util.DocumentLoadRunnable;
import org.apache.batik.util.DocumentLoadingEvent;
import org.apache.batik.util.DocumentPropertyEvent;
import org.w3c.dom.svg.SVGAElement;

public class JSVGApplet
extends JApplet
implements UserAgent,
DocumentListener {
    protected Thread thread;
    protected String userLanguages = "en";
    protected String userStyleSheetURI;
    protected JSVGCanvas canvas;
    protected SVGDocumentFactory df;
    protected EventDispatcher eventDispatcher;
    protected static final Cursor DEFAULT_CURSOR = new Cursor(0);
    protected static final Cursor WAIT_CURSOR = new Cursor(3);

    public String getAppletInfo() {
        return "$Id: JSVGApplet.java,v 1.10 2001/01/29 10:28:11 tkormann Exp $\nCopyright (C) The Apache Software Foundation. All rights reserved.\nThis software is published under the terms of the Apache Software License\nversion 1.1, a copy of which has been included with this distribution in\nthe LICENSE file.";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"svg", "url", "image to display"}};
        return stringArray;
    }

    public void init() {
        CSSDocumentHandler.setParserClassName("org.w3c.flute.parser.Parser");
        this.df = new SAXSVGDocumentFactory(this.getXMLParserClassName());
        this.canvas = new JSVGCanvas(this);
        this.eventDispatcher = new AWTEventDispatcher(this.canvas.getRendererFactory().getRenderContext());
        this.canvas.setPreferredSize(new Dimension(600, 400));
        this.getContentPane().add((Component)this.canvas, "Center");
        String string = this.getParameter("svg");
        try {
            this.loadDocument(string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Zoom In");
        jMenuItem.addActionListener(this.canvas.getAction("ZoomInAction"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom Out");
        jMenuItem.addActionListener(this.canvas.getAction("ZoomOutAction"));
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom 1:1");
        jMenuItem.addActionListener(this.canvas.getAction("UnzoomAction"));
        jPopupMenu.add(jMenuItem);
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 2) == 0 && mouseEvent.isPopupTrigger()) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public void loadDocument(String string) {
        if (string != null) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
            Thread thread = DocumentLoadRunnable.createLoaderThread(string, this, this.df);
            this.runThread(thread);
        }
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        if (documentEvent.classid == DocumentEvent.LOADING) {
            this.processDocumentLoadingEvent((DocumentLoadingEvent)documentEvent);
        } else if (documentEvent.classid == DocumentEvent.PROPERTY) {
            this.processDocumentPropertyEvent((DocumentPropertyEvent)documentEvent);
        }
    }

    public void processDocumentLoadingEvent(DocumentLoadingEvent documentLoadingEvent) {
        switch (documentLoadingEvent.type) {
            case 1: {
                this.setCursor(WAIT_CURSOR);
                break;
            }
            case 2: {
                DefaultSVGContext defaultSVGContext = new DefaultSVGContext(){

                    public float getPixelToMM() {
                        return JSVGApplet.this.getPixelToMM();
                    }

                    public float getViewportWidth() {
                        return (float)JSVGApplet.this.canvas.getSize().getWidth();
                    }

                    public float getViewportHeight() {
                        return (float)JSVGApplet.this.canvas.getSize().getHeight();
                    }
                };
                SVGOMDocument sVGOMDocument = (SVGOMDocument)documentLoadingEvent.getValue();
                defaultSVGContext.setUserStyleSheetURI(this.userStyleSheetURI);
                sVGOMDocument.setSVGContext(defaultSVGContext);
                this.canvas.setSVGDocument(null);
                break;
            }
            case 15: {
                SVGOMDocument sVGOMDocument = (SVGOMDocument)documentLoadingEvent.getValue();
                this.canvas.setSVGDocument(sVGOMDocument);
                this.setCursor(DEFAULT_CURSOR);
                break;
            }
            case 254: {
                break;
            }
            case 255: {
                this.displayError("Document.failed: " + documentLoadingEvent.getException().toString());
            }
        }
    }

    public void processDocumentPropertyEvent(DocumentPropertyEvent documentPropertyEvent) {
        switch (documentPropertyEvent.type) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public Dimension2D getViewportSize() {
        return this.getSize();
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void displayError(String string) {
        System.err.println(string);
    }

    public void displayError(Exception exception) {
        System.err.println(exception);
    }

    public void displayMessage(String string) {
        System.out.println(string);
    }

    public float getPixelToMM() {
        return 0.33f;
    }

    public String getLanguages() {
        return this.userLanguages;
    }

    public String getUserStyleSheetURI() {
        return this.userStyleSheetURI;
    }

    public void openLink(SVGAElement sVGAElement) {
    }

    public void setSVGCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    public synchronized void runThread(Thread thread) {
        this.thread = thread;
        this.thread.start();
    }

    public String getXMLParserClassName() {
        return "org.apache.crimson.parser.XMLReaderImpl";
    }

    public AffineTransform getTransform() {
        return this.canvas.getTransform();
    }

    public Point getClientAreaLocationOnScreen() {
        return this.canvas.getLocationOnScreen();
    }
}

