/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class XRTreeFrag
extends XObject {
    public XRTreeFrag(DocumentFragment documentFragment) {
        super(documentFragment);
    }

    public NodeIterator asNodeIterator() {
        if (this.m_obj instanceof NodeIterator) {
            return (NodeIterator)this.m_obj;
        }
        return new NodeIteratorWrapper(this.rtree());
    }

    public boolean bool() {
        return true;
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return null;
    }

    public boolean equals(XObject xObject) throws TransformerException {
        if (xObject.getType() == 4) {
            return xObject.equals(this);
        }
        if (xObject.getType() == 1) {
            return this.bool() == xObject.bool();
        }
        if (xObject.getType() == 2) {
            return this.num() == xObject.num();
        }
        if (xObject.getType() == 4) {
            return this.str().equals(xObject.str());
        }
        if (xObject.getType() == 3) {
            return this.str().equals(xObject.str());
        }
        if (xObject.getType() == 5) {
            return this.str().equals(xObject.str());
        }
        return super.equals(xObject);
    }

    public int getType() {
        return 5;
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() {
        String string = DOMHelper.getNodeData((DocumentFragment)this.m_obj);
        double d = string != null ? XString.castToNum(string.trim()) : Double.NaN;
        return d;
    }

    public DocumentFragment rtree() {
        return (DocumentFragment)this.m_obj;
    }

    public String str() {
        String string = DOMHelper.getNodeData((DocumentFragment)this.m_obj);
        return string == null ? "" : string;
    }

    class NodeIteratorWrapper
    implements NodeIterator {
        private int m_pos = -1;
        private DocumentFragment m_docFrag;

        NodeIteratorWrapper(DocumentFragment documentFragment) {
            this.m_docFrag = documentFragment;
        }

        public void detach() {
        }

        public boolean getExpandEntityReferences() {
            return true;
        }

        public NodeFilter getFilter() {
            return null;
        }

        public Node getRoot() {
            return null;
        }

        public int getWhatToShow() {
            return -1;
        }

        public Node nextNode() throws DOMException {
            if (this.m_pos == -1) {
                this.m_pos = 0;
                return this.m_docFrag;
            }
            return null;
        }

        public Node previousNode() throws DOMException {
            if (this.m_pos == 0) {
                this.m_pos = -1;
                return this.m_docFrag;
            }
            return null;
        }
    }
}

