/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import org.w3c.dom.Node;

public class NodeVector
implements Serializable,
Cloneable {
    private int m_blocksize;
    private Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = 0;
    }

    public void addElement(Node node) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[this.m_firstFree] = node;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodeVector) {
        int n = nodeVector.size();
        if (this.m_map == null) {
            this.m_mapSize = n + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += n + this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + n);
            this.m_map = nodeArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n);
        this.m_firstFree += n;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector nodeVector = (NodeVector)super.clone();
        if (this.m_map != null && this.m_map == nodeVector.m_map) {
            nodeVector.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeVector.m_map, 0, this.m_map.length);
        }
        return nodeVector;
    }

    public boolean contains(Node node) {
        if (this.m_map == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Node elementAt(int n) {
        if (this.m_map == null) {
            return null;
        }
        return this.m_map[n];
    }

    public int indexOf(Node node) {
        if (this.m_map == null) {
            return -1;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(Node node, int n) {
        if (this.m_map == null) {
            return -1;
        }
        int n2 = n;
        while (n2 < this.m_firstFree) {
            Node node2 = this.m_map[n2];
            if (node2 != null && node2.equals(node)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void insertElementAt(Node node, int n) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n, this.m_map, n + 1, this.m_firstFree - n);
        }
        this.m_map[n] = node;
        ++this.m_firstFree;
    }

    public final Node peepOrNull() {
        return this.m_map != null && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node node = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return node;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public final void push(Node node) {
        int n = this.m_firstFree;
        if (n + 1 >= this.m_mapSize) {
            if (this.m_map == null) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, n + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[n] = node;
        this.m_firstFree = ++n;
    }

    public final void pushPair(Node node, Node node2) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree);
            this.m_map = nodeArray;
        }
        this.m_map[this.m_firstFree] = node;
        this.m_map[this.m_firstFree + 1] = node2;
        this.m_firstFree += 2;
    }

    public void removeAllElements() {
        if (this.m_map == null) {
            return;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            this.m_map[n] = null;
            ++n;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(Node node) {
        if (this.m_map == null) {
            return false;
        }
        int n = 0;
        while (n < this.m_firstFree) {
            Node node2 = this.m_map[n];
            if (node2 != null && node2.equals(node)) {
                if (n > this.m_firstFree) {
                    System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
                } else {
                    this.m_map[n] = null;
                }
                --this.m_firstFree;
                return true;
            }
            ++n;
        }
        return false;
    }

    public void removeElementAt(int n) {
        if (this.m_map == null) {
            return;
        }
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n - 1, this.m_firstFree - n);
        } else {
            this.m_map[n] = null;
        }
    }

    public void setElementAt(Node node, int n) {
        if (this.m_map == null) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[n] = node;
    }

    public final void setTail(Node node) {
        this.m_map[this.m_firstFree - 1] = node;
    }

    public final void setTailSub1(Node node) {
        this.m_map[this.m_firstFree - 2] = node;
    }

    public int size() {
        return this.m_firstFree;
    }
}

