/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;

public class StylesheetComposed
extends Stylesheet {
    private int m_importNumber = -1;
    private int m_importCountComposed;
    private transient Vector m_includesComposed;

    public StylesheetComposed(Stylesheet stylesheet) {
        super(stylesheet);
    }

    public StylesheetComposed getImportComposed(int n) throws ArrayIndexOutOfBoundsException {
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        return stylesheetRoot.getGlobalImport(1 + this.m_importNumber + n);
    }

    public int getImportCountComposed() {
        return this.m_importCountComposed;
    }

    public Stylesheet getIncludeComposed(int n) throws ArrayIndexOutOfBoundsException {
        if (n == -1) {
            return this;
        }
        if (this.m_includesComposed == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (Stylesheet)this.m_includesComposed.elementAt(n);
    }

    public int getIncludeCountComposed() {
        return this.m_includesComposed != null ? this.m_includesComposed.size() : 0;
    }

    public boolean isAggregatedType() {
        return true;
    }

    public void recompose(Vector vector) throws TransformerException {
        this.recomposeImports();
        this.recomposeIncludes(this);
        int n = this.getIncludeCountComposed();
        int n2 = -1;
        while (n2 < n) {
            Stylesheet stylesheet = this.getIncludeComposed(n2);
            int n3 = stylesheet.getOutputCount();
            int n4 = 0;
            while (n4 < n3) {
                vector.addElement(stylesheet.getOutput(n4));
                ++n4;
            }
            n3 = stylesheet.getAttributeSetCount();
            int n5 = 0;
            while (n5 < n3) {
                vector.addElement(stylesheet.getAttributeSet(n5));
                ++n5;
            }
            n3 = stylesheet.getDecimalFormatCount();
            int n6 = 0;
            while (n6 < n3) {
                vector.addElement(stylesheet.getDecimalFormat(n6));
                ++n6;
            }
            n3 = stylesheet.getKeyCount();
            int n7 = 0;
            while (n7 < n3) {
                vector.addElement(stylesheet.getKey(n7));
                ++n7;
            }
            n3 = stylesheet.getNamespaceAliasCount();
            int n8 = 0;
            while (n8 < n3) {
                vector.addElement(stylesheet.getNamespaceAlias(n8));
                ++n8;
            }
            n3 = stylesheet.getTemplateCount();
            int n9 = 0;
            while (n9 < n3) {
                vector.addElement(stylesheet.getTemplate(n9));
                ++n9;
            }
            n3 = stylesheet.getVariableOrParamCount();
            int n10 = 0;
            while (n10 < n3) {
                vector.addElement(stylesheet.getVariableOrParam(n10));
                ++n10;
            }
            n3 = stylesheet.getStripSpaceCount();
            int n11 = 0;
            while (n11 < n3) {
                vector.addElement(stylesheet.getStripSpace(n11));
                ++n11;
            }
            n3 = stylesheet.getPreserveSpaceCount();
            int n12 = 0;
            while (n12 < n3) {
                vector.addElement(stylesheet.getPreserveSpace(n12));
                ++n12;
            }
            ++n2;
        }
    }

    void recomposeImports() {
        this.m_importNumber = this.getStylesheetRoot().getImportNumber(this);
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        int n = stylesheetRoot.getGlobalImportCount();
        this.m_importCountComposed = n - this.m_importNumber - 1;
    }

    void recomposeIncludes(Stylesheet stylesheet) {
        int n = stylesheet.getIncludeCount();
        if (n > 0) {
            if (this.m_includesComposed == null) {
                this.m_includesComposed = new Vector();
            }
            int n2 = 0;
            while (n2 < n) {
                Stylesheet stylesheet2 = stylesheet.getInclude(n2);
                this.m_includesComposed.addElement(stylesheet2);
                this.recomposeIncludes(stylesheet2);
                ++n2;
            }
        }
    }

    public void recomposeTemplates(boolean bl) throws TransformerException {
    }
}

