/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXNotSupportedException;

public class Extensions {
    private Extensions() {
    }

    public static NodeSet difference(NodeIterator nodeIterator, NodeIterator nodeIterator2) throws TransformerException {
        NodeSet nodeSet = new NodeSet(nodeIterator);
        NodeSet nodeSet2 = new NodeSet(nodeIterator2);
        NodeSet nodeSet3 = new NodeSet();
        nodeSet3.setShouldCacheNodes(true);
        int n = 0;
        while (n < nodeSet.getLength()) {
            Node node = nodeSet.elementAt(n);
            if (!nodeSet2.contains(node)) {
                nodeSet3.addElement(node);
            }
            ++n;
        }
        return nodeSet3;
    }

    public static NodeSet distinct(NodeIterator nodeIterator) throws TransformerException {
        NodeSet nodeSet = new NodeSet(nodeIterator);
        NodeSet nodeSet2 = new NodeSet();
        nodeSet2.setShouldCacheNodes(true);
        Hashtable<String, Node> hashtable = new Hashtable<String, Node>();
        int n = 0;
        while (n < nodeSet.getLength()) {
            Node node = nodeSet.elementAt(n);
            String string = DOMHelper.getNodeData(node);
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, node);
                nodeSet2.addElement(node);
            }
            ++n;
        }
        return nodeSet2;
    }

    public static XObject evaluate(ExpressionContext expressionContext, String string) throws SAXNotSupportedException, Exception {
        if (expressionContext instanceof XPathContext) {
            XPathContext xPathContext = (XPathContext)expressionContext;
            XPath xPath = new XPath(string, xPathContext.getSAXLocator(), xPathContext.getNamespaceContext(), 0);
            return xPath.execute(xPathContext, expressionContext.getContextNode(), xPathContext.getNamespaceContext());
        }
        throw new SAXNotSupportedException("Invalid context passed to evaluate " + expressionContext);
    }

    public static boolean hasSameNodes(NodeIterator nodeIterator, NodeIterator nodeIterator2) {
        NodeSet nodeSet = new NodeSet(nodeIterator);
        NodeSet nodeSet2 = new NodeSet(nodeIterator2);
        if (nodeSet.getLength() != nodeSet2.getLength()) {
            return false;
        }
        int n = 0;
        while (n < nodeSet.getLength()) {
            Node node = nodeSet.elementAt(n);
            if (!nodeSet2.contains(node)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static NodeSet intersection(NodeIterator nodeIterator, NodeIterator nodeIterator2) throws TransformerException {
        NodeSet nodeSet = new NodeSet(nodeIterator);
        NodeSet nodeSet2 = new NodeSet(nodeIterator2);
        NodeSet nodeSet3 = new NodeSet();
        nodeSet3.setShouldCacheNodes(true);
        int n = 0;
        while (n < nodeSet.getLength()) {
            Node node = nodeSet.elementAt(n);
            if (nodeSet2.contains(node)) {
                nodeSet3.addElement(node);
            }
            ++n;
        }
        return nodeSet3;
    }

    public static NodeSet nodeset(ExpressionContext expressionContext, Object object) {
        if (object instanceof NodeIterator) {
            return new NodeSet((NodeIterator)object);
        }
        String string = object instanceof String ? (String)object : (object instanceof Boolean ? new XBoolean((Boolean)object).str() : (object instanceof Double ? new XNumber((Double)object).str() : object.toString()));
        Document document = expressionContext.getContextNode().getOwnerDocument();
        Text text = document.createTextNode(string);
        DocumentFragment documentFragment = document.createDocumentFragment();
        documentFragment.appendChild(text);
        return new NodeSet(documentFragment);
    }

    public static NodeSet tokenize(ExpressionContext expressionContext, String string) {
        return Extensions.tokenize(expressionContext, string, " \t\n\r");
    }

    public static NodeSet tokenize(ExpressionContext expressionContext, String string, String string2) {
        Document document = expressionContext.getContextNode().getOwnerDocument();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        NodeSet nodeSet = new NodeSet();
        while (stringTokenizer.hasMoreTokens()) {
            nodeSet.addNode(document.createTextNode(stringTokenizer.nextToken()));
        }
        return nodeSet;
    }
}

