/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.pool;

import java.util.Stack;
import java.util.Vector;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.ThreadSafe;
import org.apache.excalibur.pool.ObjectFactory;
import org.apache.excalibur.pool.Pool;

public class AbstractPool
extends AbstractLoggable
implements Pool,
ThreadSafe {
    protected final ObjectFactory m_factory;
    protected final int m_min;
    protected int m_max;
    protected int m_currentCount = 0;
    protected Vector m_active = new Vector();
    protected Stack m_ready = new Stack();

    protected void init() throws Exception {
        int n = 0;
        while (n < this.m_min) {
            this.m_ready.push(this.m_factory.newInstance());
            ++this.m_currentCount;
            ++n;
        }
    }

    public int size() {
        int n = this.m_currentCount;
        return n;
    }

    public synchronized Poolable get() throws Exception {
        Poolable poolable = null;
        if (this.m_ready.size() == 0) {
            poolable = (Poolable)this.m_factory.newInstance();
            ++this.m_currentCount;
        } else {
            poolable = (Poolable)this.m_ready.pop();
        }
        this.m_active.addElement(poolable);
        if (this.getLogger() != null) {
            this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": requested from the pool.");
        }
        return poolable;
    }

    public synchronized void put(Poolable poolable) {
        this.m_active.removeElement(poolable);
        this.m_ready.push(poolable);
        if (this.getLogger() != null) {
            this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": returned to the pool.");
        }
    }

    public AbstractPool(ObjectFactory objectFactory, int n, int n2) throws Exception {
        this.m_factory = objectFactory;
        int n3 = n2;
        int n4 = n;
        if (n < 0) {
            if (this.getLogger() != null) {
                this.getLogger().warn("Minumum number of poolables specified is less than 0, using 0");
            }
            n4 = 0;
        } else {
            n4 = n;
        }
        if (n2 < n || n2 < 1) {
            if (this.getLogger() != null) {
                this.getLogger().warn("Maximum number of poolables specified must be at least 1 and must be greater than the minumum number of connections");
            }
            n3 = n > 1 ? n : 1;
        } else {
            n3 = n2;
        }
        this.m_max = n3;
        this.m_min = n4;
        if (!(this instanceof Initializable)) {
            this.init();
        }
    }
}

