/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.util.ProxyClassLoader;
import org.apache.log.Logger;

public final class ProxyGenerator {
    protected static final boolean DEBUG = false;
    protected static final Logger LOGGER = null;
    protected static final Object MONITOR = new Object();
    protected static final ClassType BASE_CLASS = (ClassType)Type.getType((String)"java.lang.Object");
    protected static long c_currentId;

    protected static long getNextId() {
        Object object = MONITOR;
        synchronized (object) {
            long l = c_currentId++;
            Object var1_2 = null;
            return l;
        }
    }

    public static Object generateProxy(Object object, Class[] classArray) throws IllegalArgumentException {
        int n = 0;
        while (n < classArray.length) {
            if (!classArray[n].isInterface()) {
                throw new IllegalArgumentException("Class " + classArray[n].getName() + " is not an interface");
            }
            if (!classArray[n].isInstance(object)) {
                throw new IllegalArgumentException("Object does not implement interface " + classArray[n].getName());
            }
            ++n;
        }
        HashMap hashMap = ProxyGenerator.determineMethods(classArray);
        String string = "org.apache.avalon.tmp.Proxy" + ProxyGenerator.getNextId();
        ClassType classType = ProxyGenerator.createProxyType(string);
        ProxyGenerator.generateInterfaces(classType, classArray);
        ClassType classType2 = (ClassType)Type.make(object.getClass());
        classType2.doFixups();
        ProxyGenerator.generateBase(classType, (Type)classType2);
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ProxyGenerator.generateMethod(classType, classType2, (java.lang.reflect.Method)iterator.next());
        }
        classType.doFixups();
        Class clazz = null;
        try {
            byte[] byArray = classType.writeToArray();
            ProxyClassLoader proxyClassLoader = new ProxyClassLoader(object.getClass().getClassLoader());
            clazz = proxyClassLoader.loadClass(string, true, byArray);
            Constructor constructor = clazz.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    protected static ClassType createProxyType(String string) {
        ClassType classType = new ClassType(string);
        classType.setModifiers(49);
        classType.setSuper(BASE_CLASS);
        return classType;
    }

    protected static void generateInterfaces(ClassType classType, Class[] classArray) {
        ClassType[] classTypeArray = new ClassType[classArray.length];
        int n = 0;
        while (n < classTypeArray.length) {
            classTypeArray[n] = (ClassType)Type.getType((String)classArray[n].getName());
            ++n;
        }
        classType.setInterfaces(classTypeArray);
    }

    protected static void generateMethod(ClassType classType, ClassType classType2, java.lang.reflect.Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        int n = 0;
        while (n < typeArray.length) {
            typeArray[n] = Type.getType((String)classArray[n].getName());
            ++n;
        }
        Type type = Type.getType((String)method.getReturnType().getName());
        Method method2 = classType.addMethod(method.getName(), 1, typeArray, type);
        method2.init_param_slots();
        method2.pushScope();
        CodeAttr codeAttr = method2.getCode();
        Field field = classType.getField("m_core");
        codeAttr.emitPushThis();
        codeAttr.emitGetField(field);
        int n2 = 0;
        while (n2 < typeArray.length) {
            codeAttr.emitLoad(codeAttr.getArg(1 + n2));
            ++n2;
        }
        Method method3 = classType2.getMethod(method.getName(), typeArray);
        codeAttr.emitInvokeVirtual(method3);
        codeAttr.emitReturn();
        method2.popScope();
    }

    protected static void generateBase(ClassType classType, Type type) {
        Field field = classType.addField("m_core", type);
        field.flags |= 2;
        Method method = classType.addMethod("<init>", 1, new Type[]{type}, (Type)Type.void_type);
        Method method2 = classType.getSuperclass().addMethod("<init>", 1, null, (Type)Type.void_type);
        method.init_param_slots();
        method.pushScope();
        CodeAttr codeAttr = method.getCode();
        codeAttr.emitPushThis();
        codeAttr.emitInvokeSpecial(method2);
        codeAttr.emitPushThis();
        codeAttr.emitLoad(codeAttr.getArg(1));
        codeAttr.emitPutField(field);
        codeAttr.emitReturn();
        method.popScope();
    }

    protected static HashMap determineMethods(Class[] classArray) {
        HashMap<String, java.lang.reflect.Method> hashMap = new HashMap<String, java.lang.reflect.Method>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < classArray.length) {
            java.lang.reflect.Method[] methodArray = classArray[n].getMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                stringBuffer.append(methodArray[n2].getName());
                stringBuffer.append('(');
                Class<?>[] classArray2 = methodArray[n2].getParameterTypes();
                int n3 = 0;
                while (n3 < classArray2.length) {
                    stringBuffer.append(classArray2[n3].getName());
                    stringBuffer.append(' ');
                    ++n3;
                }
                stringBuffer.append(";)");
                hashMap.put(stringBuffer.toString(), methodArray[n2]);
                stringBuffer.setLength(0);
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    private ProxyGenerator() {
    }
}

