/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.exception.ReferenceException;
import org.apache.velocity.runtime.parser.Parser;
import org.apache.velocity.runtime.parser.node.NodeUtils;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;

public class ASTReference
extends SimpleNode {
    private static final int NORMAL_REFERENCE = 1;
    private static final int FORMAL_REFERENCE = 2;
    private static final int QUIET_REFERENCE = 3;
    private int referenceType;
    private String nullString;
    private String rootString;
    private boolean escaped = false;
    private boolean computableReference = true;
    private String prefix = "";

    public ASTReference(int id) {
        super(id);
    }

    public ASTReference(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object init(InternalContextAdapter context, Object data) throws Exception {
        super.init(context, data);
        this.rootString = this.getRoot();
        return data;
    }

    public Object execute(Object o, InternalContextAdapter context) throws MethodInvocationException {
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            return null;
        }
        int children = this.jjtGetNumChildren();
        try {
            int i = 0;
            while (i < children) {
                result = this.jjtGetChild(i).execute(result, context);
                if (result == null) {
                    return null;
                }
                ++i;
            }
            return result;
        }
        catch (MethodInvocationException mie) {
            Runtime.error("Method " + mie.getMethodName() + " threw exception for reference $" + this.rootString + " in template " + context.getCurrentTemplateName() + " at " + " [" + this.getLine() + "," + this.getColumn() + "]");
            mie.setReferenceName(this.rootString);
            throw mie;
        }
    }

    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException {
        Object value = this.execute(null, context);
        if (this.escaped) {
            if (value == null) {
                writer.write(NodeUtils.specialText(this.getFirstToken()) + this.prefix + "\\" + this.nullString);
            } else {
                writer.write(NodeUtils.specialText(this.getFirstToken()) + this.prefix + this.nullString);
            }
            return true;
        }
        if (value == null) {
            writer.write(NodeUtils.specialText(this.getFirstToken()) + this.prefix + this.prefix + this.nullString);
            if (this.referenceType != 3 && Runtime.getBoolean("runtime.log.invalid.references", true)) {
                Runtime.warn(new ReferenceException("reference : template = " + context.getCurrentTemplateName(), this));
            }
        } else {
            writer.write(NodeUtils.specialText(this.getFirstToken()) + this.prefix + value.toString());
        }
        return true;
    }

    public boolean evaluate(InternalContextAdapter context) throws MethodInvocationException {
        Object value = this.execute(null, context);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false;
        }
        return true;
    }

    public Object value(InternalContextAdapter context) throws MethodInvocationException {
        return this.computableReference ? this.execute(null, context) : null;
    }

    public boolean setValue(InternalContextAdapter context, Object value) throws MethodInvocationException {
        Object result = this.getVariableValue(context, this.rootString);
        if (result == null) {
            Runtime.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
            return false;
        }
        int children = this.jjtGetNumChildren();
        int i = 0;
        while (i < children - 1) {
            result = this.jjtGetChild(i).execute(result, context);
            if (result == null) {
                Runtime.error(new ReferenceException("reference set : template = " + context.getCurrentTemplateName(), this));
                return false;
            }
            ++i;
        }
        String identifier = this.jjtGetChild((int)(children - 1)).getFirstToken().image;
        try {
            Class[] params = new Class[]{value.getClass()};
            Class<?> c = result.getClass();
            Method m = null;
            try {
                m = c.getMethod("set" + identifier, params);
            }
            catch (NoSuchMethodException nsme2) {
                StringBuffer sb = new StringBuffer("set");
                sb.append(identifier);
                if (Character.isLowerCase(sb.charAt(3))) {
                    sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
                } else {
                    sb.setCharAt(3, Character.toLowerCase(sb.charAt(3)));
                }
                m = c.getMethod(sb.toString(), params);
            }
            Object[] args = new Object[]{value};
            m.invoke(result, args);
        }
        catch (NoSuchMethodException nsme) {
            if (result instanceof Map) {
                try {
                    ((Map)result).put(identifier, value);
                }
                catch (Exception ex) {
                    Runtime.error("ASTReference Map.put : exception : " + ex + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
                    return false;
                }
            }
            Runtime.error("ASTReference : cannot find " + identifier + " as settable property or key to Map in" + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
            return false;
        }
        catch (Exception e) {
            Runtime.error("ASTReference setValue() : exception : " + e + " template = " + context.getCurrentTemplateName() + " [" + this.getLine() + "," + this.getColumn() + "]");
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private String getRoot() {
        block10: {
            t = this.getFirstToken();
            slashbang = t.image.indexOf("\\!");
            if (slashbang == -1) break block10;
            i = 0;
            len = t.image.length();
            i = t.image.indexOf("$");
            if (i != -1) ** GOTO lbl13
            Runtime.error("ASTReference.getRoot() : internal error : no $ found for slashbang.");
            this.computableReference = false;
            this.nullString = t.image;
            return this.nullString;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl13:
                // 2 sources

                ** while (i < len && t.image.charAt((int)i) != '\\')
            }
lbl14:
            // 1 sources

            start = i;
            count = 0;
            while (i < len && t.image.charAt(i++) == '\\') {
                ++count;
            }
            this.nullString = t.image.substring(0, start);
            this.nullString = this.nullString + t.image.substring(start, start + count - 1);
            this.nullString = this.nullString + t.image.substring(start + count);
            this.computableReference = false;
            return this.nullString;
        }
        this.escaped = false;
        if (t.image.startsWith("\\")) {
            i = 0;
            len = t.image.length();
            while (i < len && t.image.charAt(i) == '\\') {
                ++i;
            }
            if (i % 2 != 0) {
                this.escaped = true;
            }
            if (i > 0) {
                this.prefix = t.image.substring(0, i / 2);
            }
            t.image = t.image.substring(i);
        }
        this.nullString = this.literal();
        if (t.image.startsWith("$!")) {
            this.referenceType = 3;
            if (!this.escaped) {
                this.nullString = "";
            }
            if (t.image.startsWith("$!{")) {
                return t.next.image;
            }
            return t.image.substring(2);
        }
        if (t.image.equals("${")) {
            this.referenceType = 2;
            return t.next.image;
        }
        this.referenceType = 1;
        return t.image.substring(1);
    }

    public Object getVariableValue(Context context, String variable) {
        return context.get(variable);
    }
}

