/*

 ============================================================================
                   The Apache Software License, Version 1.1
 ============================================================================
 
 Copyright (C) 1999-2000 The Apache Software Foundation. All rights reserved.
 
 Redistribution and use in source and binary forms, with or without modifica-
 tion, are permitted provided that the following conditions are met:
 
 1. Redistributions of  source code must  retain the above copyright  notice,
    this list of conditions and the following disclaimer.
 
 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
 
 3. The end-user documentation included with the redistribution, if any, must
    include  the following  acknowledgment:  "This product includes  software
    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
    Alternately, this  acknowledgment may  appear in the software itself,  if
    and wherever such third-party acknowledgments normally appear.
 
 4. The names "Cocoon" and  "Apache Software Foundation"  must not be used to
    endorse  or promote  products derived  from this  software without  prior
    written permission. For written permission, please contact
    apache@apache.org.
 
 5. Products  derived from this software may not  be called "Apache", nor may
    "Apache" appear  in their name,  without prior written permission  of the
    Apache Software Foundation.
 
 THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 This software  consists of voluntary contributions made  by many individuals
 on  behalf of the Apache Software  Foundation and was  originally created by
 Stefano Mazzocchi  <stefano@apache.org>. For more  information on the Apache 
 Software Foundation, please see <http://www.apache.org/>.
 
 */
 
package org.apache.cocoon.processor.xsp.library.fp;

import java.io.*;
import java.net.*;
import java.util.*;
import java.text.*;

import org.w3c.dom.*;

import javax.servlet.*;
import javax.servlet.http.*;

import org.apache.cocoon.processor.xsp.*;
import org.apache.cocoon.framework.XObject;

public class fpError {

	Node cNode = null;
	Node eNode = null;
	String eMessage = null;
	String eLabel = null;
	
  	public fpError (Node cNode, Node eNode, String eMessage, String eLabel) {
  		this.cNode = cNode;
  		this.eNode = eNode;
  		this.eMessage = eMessage;
  		this.eLabel = eLabel;
  		System.out.println(getErrorString());
  	}

	public String getErrorString () {
		StringBuffer sb = new StringBuffer();
		sb.append("fp error on:					" + ((cNode != null) ? cNode.getNodeName(): "unkown") + "\r");
		sb.append("fp error-message:		" + eMessage + "\r");
		sb.append("fp error-node-name:	" + ((eNode != null) ? eNode.getNodeName(): "unkown") + "\r");
		sb.append("fp error-node-type:	" + ((eNode != null) ? String.valueOf(eNode.getNodeType()): "unkown") + "\r");
		return sb.toString();
	}

	public Node getErrorNode(Node rNode) {
		Element errors = null, msg;
		try {
			Document doc = rNode.getOwnerDocument();
			errors = doc.createElement("fp-error");
			errors.setAttribute("id", "fp-" + eLabel);
			msg = doc.createElement("fp-error-message");
			errors.appendChild(doc.createTextNode("\n\t"));
			msg.appendChild(doc.createTextNode(eMessage));
			errors.appendChild(msg);
			msg = doc.createElement("fp-error-node-name");
			msg.appendChild(doc.createTextNode("\n\t"));
			msg.appendChild(doc.createTextNode(eNode.getNodeName()));
			errors.appendChild(msg);
			msg = doc.createElement("fp-error-node-type");
			msg.appendChild(doc.createTextNode("\n\t"));
			msg.appendChild(doc.createTextNode(String.valueOf(eNode.getNodeType())));
			errors.appendChild(msg);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println(e.getMessage());
		}
		return errors;
	}
}
