/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.java.util.ConfigurationsRepository;

public class Configurations {
    private Configurations defaults;
    private ConfigurationsRepository repository;

    public Configurations() {
        this(null, null);
    }

    public Configurations(Configurations defaults) {
        this(null, defaults);
    }

    public Configurations(ConfigurationsRepository properties) {
        this(properties, null);
    }

    public Configurations(ConfigurationsRepository properties, Configurations defaults) {
        this.repository = properties;
        this.defaults = defaults;
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = new Boolean((String)value);
            this.repository.put(key, b);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Boolean object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b = new Byte((String)value);
            this.repository.put(key, b);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Byte object");
    }

    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(String key, Double defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d = new Double((String)value);
            this.repository.put(key, d);
            return d;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Double object");
    }

    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(String key, Float defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f = new Float((String)value);
            this.repository.put(key, f);
            return f;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Float object");
    }

    public int getInteger(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public int getInteger(String key, int defaultValue) {
        return this.getInteger(key, new Integer(defaultValue));
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            this.repository.put(key, i);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Integer object");
    }

    public Enumeration getKeys() {
        return this.repository.keys();
    }

    public Enumeration getKeys(String prefix) {
        Enumeration keys = this.repository.keys();
        Vector matchingKeys = new Vector();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            matchingKeys.addElement(key);
        }
        return matchingKeys.elements();
    }

    public Enumeration getList(String key) {
        return this.getVector(key, null).elements();
    }

    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(String key, Long defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l = new Long((String)value);
            this.repository.put(key, l);
            return l;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Long object");
    }

    public Properties getProperties(String key) {
        return this.getProperties(key, new Properties());
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = new Properties(defaults);
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                throw new IllegalArgumentException("'" + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            ((Hashtable)props).put(pkey, pvalue);
            ++i;
        }
        return props;
    }

    public Hashtable getRepository() {
        return this.repository;
    }

    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException(String.valueOf(key) + " doesn't map to an existing object");
    }

    public Short getShort(String key, Short defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            this.repository.put(key, s);
            return s;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Short object");
    }

    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getString(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a String object");
    }

    public String[] getStringArray(String key) {
        Vector vector;
        Object value = this.repository.get(key);
        if (value instanceof String) {
            vector = new Vector(1);
            vector.addElement(value);
        } else if (value instanceof Vector) {
            vector = (Vector)value;
        } else {
            if (value == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(key);
                }
                return new String[0];
            }
            throw new ClassCastException(String.valueOf(key) + " doesn't map to a String/Vector object");
        }
        String[] tokens = new String[vector.size()];
        int i = 0;
        while (i < tokens.length) {
            tokens[i] = (String)vector.elementAt(i);
            ++i;
        }
        return tokens;
    }

    public Vector getVector(String key) {
        return this.getVector(key, null);
    }

    public Vector getVector(String key, Vector defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value instanceof String) {
            Vector<String> v = new Vector<String>(1);
            v.addElement((String)value);
            this.repository.put(key, v);
            return v;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(key, defaultValue);
            }
            return defaultValue == null ? new Vector() : defaultValue;
        }
        throw new ClassCastException(String.valueOf(key) + " doesn't map to a Vector object");
    }
}

