/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.EnumeratedAttribute;
import org.apache.tools.ant.Project;

public class IntrospectionHelper {
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private Method addText = null;
    private Class bean;
    private static Hashtable helpers = new Hashtable();
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$Location;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$tools$ant$EnumeratedAttribute;

    private IntrospectionHelper(Class bean) {
        this.bean = bean;
        Method[] methods = bean.getMethods();
        int i = 0;
        while (i < methods.length) {
            final Method m = methods[i];
            String name = m.getName();
            Class<?> returnType = m.getReturnType();
            Class<?>[] args = m.getParameterTypes();
            if (!((class$org$apache$tools$ant$Task != null ? class$org$apache$tools$ant$Task : IntrospectionHelper.class$("org.apache.tools.ant.Task")).isAssignableFrom(bean) && args.length == 1 && ("setLocation".equals(name) && (class$org$apache$tools$ant$Location != null ? class$org$apache$tools$ant$Location : IntrospectionHelper.class$("org.apache.tools.ant.Location")).equals(args[0]) || "setDescription".equals(name) && (class$java$lang$String != null ? class$java$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0]) || "setTaskType".equals(name) && (class$java$lang$String != null ? class$java$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0])))) {
                String propName;
                if ("addText".equals(name) && Void.TYPE.equals(returnType) && args.length == 1 && (class$java$lang$String != null ? class$java$lang$String : IntrospectionHelper.class$("java.lang.String")).equals(args[0])) {
                    this.addText = methods[i];
                } else if (name.startsWith("set") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray()) {
                    propName = this.getPropertyName(name, "set");
                    AttributeSetter as = this.createAttributeSetter(m, args[0]);
                    if (as != null) {
                        this.attributeTypes.put(propName, args[0]);
                        this.attributeSetters.put(propName, as);
                    }
                } else if (name.startsWith("create") && !returnType.isArray() && !returnType.isPrimitive() && args.length == 0) {
                    propName = this.getPropertyName(name, "create");
                    this.nestedTypes.put(propName, returnType);
                    this.nestedCreators.put(propName, new NestedCreator(){

                        public Object create(Object parent) throws InvocationTargetException, IllegalAccessException {
                            return m.invoke(parent, new Object[0]);
                        }
                    });
                } else if (name.startsWith("add") && Void.TYPE.equals(returnType) && args.length == 1 && !args[0].isArray() && !args[0].isPrimitive()) {
                    try {
                        final Constructor<?> c = args[0].getConstructor(new Class[0]);
                        String propName2 = this.getPropertyName(name, "add");
                        this.nestedTypes.put(propName2, args[0]);
                        this.nestedCreators.put(propName2, new NestedCreator(){

                            public Object create(Object parent) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                                Object o = c.newInstance(new Object[0]);
                                m.invoke(parent, o);
                                return o;
                            }
                        });
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            ++i;
        }
    }

    public void addText(Object element, String text) {
        if (this.addText == null) {
            String msg = "Class " + element.getClass() + " doesn't support nested text elements";
            throw new BuildException(msg);
        }
        try {
            this.addText.invoke(element, (Object[])new String[]{text});
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private AttributeSetter createAttributeSetter(final Method m, final Class arg) {
        if ((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = IntrospectionHelper.class$("java.lang.String"))).equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new String[]{value});
                }
            };
        }
        if ((class$java$lang$Character != null ? class$java$lang$Character : (class$java$lang$Character = IntrospectionHelper.class$("java.lang.Character"))).equals(arg) || Character.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Character[]{new Character(value.charAt(0))});
                }
            };
        }
        if (Byte.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Byte[]{new Byte(value)});
                }
            };
        }
        if (Short.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Short[]{new Short(value)});
                }
            };
        }
        if (Integer.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Integer[]{new Integer(value)});
                }
            };
        }
        if (Long.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Long[]{new Long(value)});
                }
            };
        }
        if (Float.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Float[]{new Float(value)});
                }
            };
        }
        if (Double.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Double[]{new Double(value)});
                }
            };
        }
        if ((class$java$lang$Boolean != null ? class$java$lang$Boolean : (class$java$lang$Boolean = IntrospectionHelper.class$("java.lang.Boolean"))).equals(arg) || Boolean.TYPE.equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new Boolean[]{new Boolean(Project.toBoolean(value))});
                }
            };
        }
        if ((class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = IntrospectionHelper.class$("java.lang.Class"))).equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, (Object[])new Class[]{Class.forName(value)});
                    }
                    catch (ClassNotFoundException ce) {
                        throw new BuildException(ce);
                    }
                }
            };
        }
        if ((class$java$io$File != null ? class$java$io$File : (class$java$io$File = IntrospectionHelper.class$("java.io.File"))).equals(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException {
                    m.invoke(parent, (Object[])new File[]{p.resolveFile(value)});
                }
            };
        }
        if ((class$org$apache$tools$ant$EnumeratedAttribute != null ? class$org$apache$tools$ant$EnumeratedAttribute : (class$org$apache$tools$ant$EnumeratedAttribute = IntrospectionHelper.class$("org.apache.tools.ant.EnumeratedAttribute"))).isAssignableFrom(arg)) {
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute ea = (EnumeratedAttribute)arg.newInstance();
                        ea.setValue(value);
                        m.invoke(parent, (Object[])new EnumeratedAttribute[]{ea});
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        try {
            final Constructor c = arg.getConstructor(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = IntrospectionHelper.class$("java.lang.String")));
            return new AttributeSetter(){

                public void set(Project p, Object parent, String value) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        m.invoke(parent, c.newInstance(value));
                    }
                    catch (InstantiationException ie) {
                        throw new BuildException(ie);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Object createElement(Object element, String elementName) throws BuildException {
        NestedCreator nc = (NestedCreator)this.nestedCreators.get(elementName);
        if (nc == null) {
            String msg = "Class " + element.getClass() + " doesn't support the nested \"" + elementName + "\" element";
            throw new BuildException(msg);
        }
        try {
            return nc.create(element);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InstantiationException ine) {
            throw new BuildException(ine);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public Class getAttributeType(String attributeName) throws BuildException {
        Class at = (Class)this.attributeTypes.get(attributeName);
        if (at == null) {
            String msg = "Class " + this.bean + " doesn't support the \"" + attributeName + "\" attribute";
            throw new BuildException(msg);
        }
        return at;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Class getElementType(String elementName) throws BuildException {
        Class nt = (Class)this.nestedTypes.get(elementName);
        if (nt == null) {
            String msg = "Class " + this.bean + " doesn't support the nested \"" + elementName + "\" element";
            throw new BuildException(msg);
        }
        return nt;
    }

    public static synchronized IntrospectionHelper getHelper(Class c) {
        IntrospectionHelper ih = (IntrospectionHelper)helpers.get(c);
        if (ih == null) {
            ih = new IntrospectionHelper(c);
            helpers.put(c, ih);
        }
        return ih;
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    private String getPropertyName(String methodName, String prefix) {
        int start = prefix.length();
        return methodName.substring(start).toLowerCase();
    }

    public void setAttribute(Project p, Object element, String attributeName, String value) throws BuildException {
        AttributeSetter as = (AttributeSetter)this.attributeSetters.get(attributeName);
        if (as == null) {
            String msg = "Class " + element.getClass() + " doesn't support the \"" + attributeName + "\" attribute";
            throw new BuildException(msg);
        }
        try {
            as.set(p, element, value);
        }
        catch (IllegalAccessException ie) {
            throw new BuildException(ie);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof BuildException) {
                throw (BuildException)t;
            }
            throw new BuildException(t);
        }
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    private static interface NestedCreator {
        public Object create(Object var1) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }

    private static interface AttributeSetter {
        public void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }
}

