/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWriter {
    protected final Document doc;
    protected Node current;

    public DOMWriter(Document doc) {
        this.doc = doc;
        this.current = doc.createDocumentFragment();
    }

    public DOMWriter(Document doc, String initElement) {
        this.doc = doc;
        this.current = doc.createElement(initElement);
    }

    public Element add(String name) throws DOMException {
        Element e = this.doc.createElement(name);
        this.appendChild(e);
        return e;
    }

    public Element add(String namespaceURI, String name) throws DOMException {
        Element e = this.doc.createElementNS(namespaceURI, name);
        this.appendChild(e);
        return e;
    }

    public Element addQuick(String name, String contents) throws DOMException {
        Element e = this.push(name);
        this.addText(contents);
        this.pop();
        return e;
    }

    public Element addQuick(String namespaceURI, String name, String contents) throws DOMException {
        Element e = this.push(namespaceURI, name);
        this.addText(contents);
        this.pop();
        return e;
    }

    public void addText(String text) throws DOMException {
        this.current.appendChild(this.doc.createTextNode(text));
    }

    public void appendChild(Node n) throws DOMException {
        this.current.appendChild(n);
    }

    public Node getCurrent() {
        return this.current;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node pop() throws DOMException {
        Node old = this.current;
        this.current = old.getParentNode();
        return old;
    }

    public Node pop(String elemName) throws DOMException {
        Element old = (Element)this.pop();
        String oldName = old.getTagName();
        if (!oldName.equals(elemName)) {
            throw new DOMException(3, "Expected '" + elemName + "', but node to be popped is '" + oldName);
        }
        return old;
    }

    public Element push(String elemName) throws DOMException {
        this.current = this.add(elemName);
        return this.current;
    }

    public Element push(String namespaceURI, String elemName) throws DOMException {
        this.current = this.add(namespaceURI, elemName);
        return this.current;
    }

    public void setAttribute(String name, String value) throws DOMException {
        ((Element)this.current).setAttribute(name, value);
    }

    public void setCurrent(Node n) {
        this.current = n;
    }
}

