/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library.fp;

import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.library.fp.fpLibrary;
import org.apache.cocoon.xml.util.XPathAPI;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class fpResource {
    protected static SerializerFactory serializer_factory = SerializerFactory.getSerializerFactory((String)"xml");
    Document workDoc = null;
    String name = "";
    Node readNode = null;
    Node writeNode = null;
    Node errorNode = null;
    File workFile = null;
    String workEncoding = "UTF-8";
    HttpServletRequest request;
    boolean changed = false;
    String xpath = "";
    public String mode = "";

    public fpResource(Node errorNode, File workFile, String xpath, String mode, String name) {
        this.errorNode = errorNode;
        this.workFile = workFile;
        this.xpath = xpath;
        this.mode = mode;
        this.name = name;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    private void init(Hashtable errors) {
        block12: {
            if (!this.notLoaded()) break block12;
            Element workNode = null;
            Node parent = null;
            NodeList nodes = null;
            this.workDoc = this.loadDocument(this.workFile, errors);
            try {
                nodes = XPathAPI.selectNodeList(this.workDoc.getDocumentElement(), this.xpath);
            }
            catch (Exception ex) {
                fpLibrary.reportError(this.errorNode, this.errorNode, errors, "Problem using the supplied XPath expression: " + this.xpath + " : " + ex.getMessage());
                ex.printStackTrace();
            }
            if (nodes != null && nodes.getLength() == 0) {
                fpLibrary.reportError(this.errorNode, this.errorNode, errors, "(init) No nodes match the given XPath expression: " + this.xpath);
            }
            try {
                this.writeNode = this.readNode = nodes.item(0);
                parent = this.readNode.getParentNode();
                if (this.mode.equalsIgnoreCase("remove")) {
                    parent.removeChild(this.readNode);
                    this.changed = true;
                } else if (this.mode.equalsIgnoreCase("insert-before")) {
                    workNode = this.workDoc.createElement(this.readNode.getNodeName());
                    parent.insertBefore(this.workDoc.createTextNode("\r\t"), this.readNode);
                    parent.insertBefore(workNode, this.readNode);
                    this.writeNode = workNode;
                } else if (this.mode.equalsIgnoreCase("insert-after")) {
                    workNode = this.workDoc.createElement(this.readNode.getNodeName());
                    Node brother = parent.getNextSibling();
                    if (brother == null) {
                        parent.appendChild(this.workDoc.createTextNode("\r\t"));
                        parent.appendChild(workNode);
                    } else {
                        parent.insertBefore(this.workDoc.createTextNode("\r\t"), brother);
                        parent.insertBefore(workNode, brother);
                    }
                    this.writeNode = workNode;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Document loadDocument(File f, Hashtable errors) {
        DOMParser parser = new DOMParser();
        try {
            InputSource is = new InputSource("file:" + f.toString());
            String enc = is.getEncoding();
            if (enc != "") {
                this.workEncoding = enc;
            }
            parser.parse(is);
        }
        catch (Exception ex) {
            fpLibrary.reportError(this.errorNode, this.errorNode, errors, "Cannot Parse: " + f.toString() + " : " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return parser.getDocument();
    }

    public boolean notLoaded() {
        return this.readNode == null;
    }

    public Node parseStringInto(Document doc, Node cNode, String val, Hashtable errors) {
        DOMParser p = new DOMParser();
        try {
            p.parse(new InputSource(new StringReader(val)));
        }
        catch (Exception ex) {
            fpLibrary.reportError(cNode, this.errorNode, errors, "Cannot Parse: " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return XSPUtil.cloneNode(p.getDocument().getDocumentElement(), doc);
    }

    public Object readAsNode(Node cNode, Hashtable errors, String select) {
        this.init(errors);
        NodeList nodes = null;
        ((Element)cNode).setAttribute("fp-type", "text/xml");
        ((Element)cNode).setAttribute("fp-action", "read");
        ((Element)cNode).setAttribute("fp-select", select);
        ((Element)cNode).setAttribute("fp-from", this.name);
        try {
            try {
                nodes = XPathAPI.selectNodeList(this.readNode, select, null);
            }
            catch (Exception ex) {
                fpLibrary.reportError(cNode, this.readNode, errors, "XPath expression error on:" + select + " : " + ex.getMessage());
                ex.printStackTrace();
                return null;
            }
            if (nodes == null || nodes.getLength() == 0) {
                fpLibrary.reportError(cNode, this.readNode, errors, "No nodes match the given XPath expression:" + select);
                return null;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return fpLibrary.NodeList2Array(nodes);
    }

    public Object readAsString(Node cNode, Hashtable errors, String select) {
        this.init(errors);
        NodeList nodes = null;
        StringBuffer temp = new StringBuffer("");
        ((Element)cNode).setAttribute("fp-type", "text/plain");
        ((Element)cNode).setAttribute("fp-action", "read");
        ((Element)cNode).setAttribute("fp-select", select);
        ((Element)cNode).setAttribute("fp-from", this.name);
        try {
            try {
                nodes = XPathAPI.selectNodeList(this.readNode, select, null);
            }
            catch (Exception ex) {
                fpLibrary.reportError(cNode, this.readNode, errors, "XPath expression error on:" + select + " : " + ex.getMessage());
                ex.printStackTrace();
            }
            if (nodes == null || nodes.getLength() == 0) {
                fpLibrary.reportError(cNode, this.readNode, errors, "No nodes match the given XPath expression:" + select);
            } else {
                int i = 0;
                while (i < nodes.getLength()) {
                    Node n = nodes.item(i);
                    NodeList nl = n.getChildNodes();
                    if (nodes.getLength() == 0) {
                        return n.getNodeValue();
                    }
                    int ix = 0;
                    while (ix < nl.getLength()) {
                        if (nl.item(ix).getNodeType() == 3) {
                            temp.append(nl.item(ix).getNodeValue());
                        }
                        ++ix;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return temp.toString();
    }

    public void save(Node cNode, Hashtable errors) {
        OutputFormat format = new OutputFormat(this.workDoc, this.workEncoding, true);
        format.setVersion("1.0");
        format.setPreserveSpace(true);
        format.setIndent(1);
        format.setIndenting(true);
        format.setLineWidth(0);
        format.setLineSeparator("\n");
        try {
            FileWriter writer = new FileWriter(this.workFile);
            Serializer serializer = serializer_factory.makeSerializer((Writer)writer, format);
            serializer.asDOMSerializer().serialize(this.workDoc);
            writer.close();
        }
        catch (Exception ex) {
            fpLibrary.reportError(cNode, cNode, errors, "Cannot save the file: " + this.workFile);
            ex.printStackTrace();
        }
    }

    public Object sureNode(String select) {
        NodeList nodes = null;
        boolean found = false;
        Element e = null;
        try {
            nodes = XPathAPI.selectNodeList(this.writeNode, select);
        }
        catch (Exception exception) {}
        if (nodes != null && nodes.getLength() > 0) {
            return fpLibrary.NodeList2Array(nodes);
        }
        StringTokenizer st = new StringTokenizer(select, "/");
        Node workNode = this.writeNode;
        String part = "";
        block2: while (st.hasMoreTokens()) {
            part = st.nextToken();
            NodeList kids = workNode.getChildNodes();
            found = false;
            int len = kids.getLength();
            int i = 0;
            while (i < len) {
                Node n = kids.item(i);
                if (n.getNodeName().equals(part)) {
                    workNode = n;
                    found = true;
                    continue block2;
                }
                ++i;
            }
        }
        if (!found) {
            part = part == "" ? select : part;
            e = this.workDoc.createElement(part);
            workNode.appendChild(this.workDoc.createTextNode("\n\t"));
            workNode.appendChild(e);
        }
        return e;
    }

    public Object writeAsTextNode(Node cNode, Hashtable errors, String select, Object value, String customMode) {
        this.init(errors);
        ((Element)cNode).setAttribute("fp-type", "text/plain");
        ((Element)cNode).setAttribute("fp-action", "write");
        ((Element)cNode).setAttribute("fp-select", select);
        ((Element)cNode).setAttribute("fp-to", this.name);
        try {
            Object fileNode = this.sureNode(select);
            if (fileNode instanceof Node[]) {
                int len = ((Node[])fileNode).length;
                if (len > 1) {
                    fpLibrary.reportError(cNode, this.readNode, errors, "Cannot write to the multiple Nodes returned by this XPath expression:" + select);
                    return null;
                }
                if (len == 1) {
                    fileNode = ((Node[])fileNode)[0];
                }
            }
            NodeList kids = ((Node)fileNode).getChildNodes();
            int i = kids.getLength() - 1;
            while (i > -1) {
                if (kids.item(i).getNodeType() == 3) {
                    ((Element)fileNode).removeChild(kids.item(i));
                }
                --i;
            }
            if (value instanceof Node[]) {
                Node[] v = (Node[])value;
                int i2 = 0;
                while (i2 < v.length) {
                    if (v[i2].getNodeType() == 3) {
                        ((Element)fileNode).appendChild(this.workDoc.createTextNode(v[i2].getNodeValue()));
                    }
                    ++i2;
                }
            } else if (value instanceof Element) {
                Node v = (Node)value;
                kids = v.getChildNodes();
                if (kids.getLength() == 0) {
                    ((Element)fileNode).appendChild(this.workDoc.createTextNode(v.getNodeValue()));
                } else {
                    int i3 = 0;
                    while (i3 < kids.getLength()) {
                        if (kids.item(i3).getNodeType() == 3) {
                            ((Element)fileNode).appendChild(this.workDoc.createTextNode(kids.item(i3).getNodeValue()));
                        }
                        ++i3;
                    }
                }
            } else {
                Text tn = this.workDoc.createTextNode((String)value);
                ((Element)fileNode).appendChild(tn);
            }
            this.changed = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

    public Object writeAsXMLNode(Node cNode, Hashtable errors, String select, Object value, String customMode) {
        this.init(errors);
        ((Element)cNode).setAttribute("fp-type", "text/xml");
        ((Element)cNode).setAttribute("fp-action", "write");
        ((Element)cNode).setAttribute("fp-select", select);
        ((Element)cNode).setAttribute("fp-to", this.name);
        try {
            Object fileNode = this.sureNode(select);
            if (fileNode instanceof Node[]) {
                int len = ((Node[])fileNode).length;
                if (len > 1) {
                    fpLibrary.reportError(cNode, this.readNode, errors, "Cannot write to the multiple Nodes returned by this XPath expression:" + select);
                    return value;
                }
                if (len == 1) {
                    fileNode = ((Node[])fileNode)[0];
                }
            }
            Node newNode = this.workDoc.createElement(((Node)fileNode).getNodeName());
            if (value instanceof Node[]) {
                Node[] v = (Node[])value;
                int i = 0;
                while (i < v.length) {
                    newNode.appendChild(XSPUtil.cloneNode(v[i], this.workDoc));
                    ++i;
                }
            } else if (value instanceof Element) {
                Node v = (Node)value;
                NodeList kids = v.getChildNodes();
                int i = 0;
                while (i < kids.getLength()) {
                    newNode.appendChild(XSPUtil.cloneNode(kids.item(i), this.workDoc));
                    ++i;
                }
            } else {
                newNode = this.parseStringInto(this.workDoc, cNode, String.valueOf(value), errors);
            }
            if (newNode != null) {
                ((Node)fileNode).getParentNode().replaceChild(newNode, (Node)fileNode);
            }
            this.changed = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }
}

