/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xslt;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.Actor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.logger.Logger;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.PINotFoundException;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ProcessorException;
import org.apache.cocoon.store.Store;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class XSLTProcessor
implements Actor,
Processor,
Status,
Defaults {
    private Monitor monitor = new Monitor(10);
    private Parser parser;
    private Store store;
    private Transformer transformer;
    private Logger logger;

    private Hashtable filterParameters(HttpServletRequest request) {
        Hashtable<String, String> params = new Hashtable<String, String>();
        Enumeration parameters = request.getParameterNames();
        if (parameters != null) {
            while (parameters.hasMoreElements()) {
                String name = (String)parameters.nextElement();
                StringCharacterIterator iter = new StringCharacterIterator(name);
                boolean valid_name = true;
                char c = iter.first();
                if (!Character.isLetter(c) && c != '_') {
                    valid_name = false;
                } else {
                    c = iter.next();
                }
                while (valid_name && c != '\uffff') {
                    if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                        valid_name = false;
                        continue;
                    }
                    c = iter.next();
                }
                if (!valid_name) continue;
                params.put(name, request.getParameter(name));
            }
        }
        return params;
    }

    private Document getDocument(Object resource) throws Exception {
        return this.parser.parse(new InputSource(resource.toString()), false);
    }

    private Object getResource(ServletContext context, HttpServletRequest request, Document document, String path, String browser) throws ProcessorException {
        Serializable resource = null;
        Enumeration pis = Utils.getAllPIs(document, "xml-stylesheet").elements();
        while (pis.hasMoreElements()) {
            String url;
            Hashtable attributes = Utils.getPIPseudoAttributes((ProcessingInstruction)pis.nextElement());
            String type = (String)attributes.get("type");
            if (type == null || !type.equals("text/xsl") || (url = (String)attributes.get("href")) == null) continue;
            Serializable local = null;
            try {
                local = url.charAt(0) == '/' ? new File(String.valueOf(Utils.getRootpath(request, context)) + url) : (url.indexOf("://") < 0 ? new File(String.valueOf(Utils.getBasepath(request, context)) + url) : new URL(url));
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessorException("Could not associate stylesheet to document: " + url + " is a malformed URL.");
            }
            String media = (String)attributes.get("media");
            if (media == null) {
                resource = local;
                if (browser != null) continue;
                break;
            }
            if (browser == null || !media.equals(browser)) continue;
            resource = local;
            break;
        }
        if (resource == null) {
            throw new ProcessorException("Could not associate stylesheet to document:  no matching stylesheet for: " + browser);
        }
        return resource;
    }

    public String getStatus() {
        return "XSLT Processor";
    }

    private Document getStylesheet(Object resource, HttpServletRequest request) throws ProcessorException {
        try {
            Object o = this.store.get(resource);
            if (o != null && !this.hasChanged(request)) {
                return (Document)o;
            }
            Document sheet = this.getDocument(resource);
            this.store.hold(resource, sheet);
            this.monitor.watch(Utils.encode(request), resource);
            return sheet;
        }
        catch (Exception e) {
            this.monitor.invalidate(request);
            throw new ProcessorException("Could not associate stylesheet to document:  error reading " + resource + ": " + e);
        }
    }

    public boolean hasChanged(Object context) {
        return this.monitor.hasChanged(Utils.encode((HttpServletRequest)context));
    }

    public void init(Director director) {
        this.parser = (Parser)director.getActor("parser");
        this.store = (Store)director.getActor("store");
        this.transformer = (Transformer)director.getActor("transformer");
        this.logger = (Logger)director.getActor("logger");
    }

    public Document process(Document document, Dictionary parameters) throws Exception {
        Document sheet = (Document)parameters.get("stylesheet");
        if (sheet != null) {
            return sheet;
        }
        HttpServletRequest request = (HttpServletRequest)parameters.get("request");
        ServletContext context = (ServletContext)parameters.get("context");
        String path = (String)parameters.get("path");
        String browser = (String)parameters.get("browser");
        Hashtable params = this.filterParameters(request);
        try {
            Object resource = this.getResource(context, request, document, path, browser);
            Document stylesheet = this.getStylesheet(resource, request);
            Document result = this.parser.createEmptyDocument();
            return this.transformer.transform(document, null, stylesheet, resource.toString(), result, params);
        }
        catch (PINotFoundException pINotFoundException) {
            return document;
        }
    }
}

