/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.Connection;
import java.util.Dictionary;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.processor.sql.QueryCreator;
import org.w3c.dom.Element;

public class DefaultQueryCreator
implements QueryCreator {
    public static final int SESSION = 1;
    public static final int REQUEST = 2;

    public String getQuery(Connection conn, String query, Element query_element, Properties query_props, Dictionary parameters) throws Exception {
        HttpServletRequest req = (HttpServletRequest)parameters.get("request");
        query = DefaultQueryCreator.substitute(query, req, query_props.getProperty("session-variable-left-delimiter"), query_props.getProperty("session-variable-right-delimiter"), 1);
        query = DefaultQueryCreator.substitute(query, req, query_props.getProperty("variable-left-delimiter"), query_props.getProperty("variable-right-delimiter"), 2);
        return query;
    }

    protected static String getValue(HttpServletRequest req, String name, int type) {
        String val = null;
        switch (type) {
            case 1: {
                val = (String)req.getSession(true).getValue(name);
                break;
            }
            case 2: {
                val = req.getParameter(name);
                break;
            }
            default: {
                val = "";
            }
        }
        return val;
    }

    protected static String substitute(String query, HttpServletRequest req, String ldelim, String rdelim, int type) {
        String name;
        String value;
        int rindex;
        int lindex;
        int llength = ldelim.length();
        int rlength = rdelim.length();
        int offset = 0;
        while ((lindex = query.indexOf(ldelim, offset)) >= 0 && (rindex = query.indexOf(rdelim, offset + llength)) >= 0 && rindex >= lindex && (value = DefaultQueryCreator.getValue(req, name = query.substring(lindex + llength, rindex), type)) != null) {
            query = String.valueOf(query.substring(0, lindex)) + value + query.substring(rindex + rlength);
            offset = lindex + value.length();
        }
        return query;
    }
}

