/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.formatter;

import java.io.Writer;
import java.util.Dictionary;
import org.apache.cocoon.formatter.Formatter;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Status;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Document;

public abstract class AbstractFormatter
implements Configurable,
Formatter,
Status {
    protected String statusMessage = "Abstract Formatter";
    protected String MIMEtype;
    protected String encoding;
    protected String doctypePublic;
    protected String doctypeSystem;
    protected String indent;
    protected String lineWidth;
    protected String preserveSpace;
    protected OutputFormat format;

    public abstract void format(Document var1, Writer var2, Dictionary var3) throws Exception;

    public String getEncoding() {
        return this.encoding;
    }

    public String getMIMEType() {
        return this.MIMEtype;
    }

    public String getStatus() {
        StringBuffer message = new StringBuffer();
        message.append(this.statusMessage);
        message.append("<br>");
        if (this.MIMEtype != null) {
            message.append("[ MIME type:  ");
            message.append(this.MIMEtype);
            message.append(" ]<br>");
        }
        if (this.encoding != null) {
            message.append("[ Encoding:  ");
            message.append(this.encoding);
            message.append(" ]<br>");
        }
        if (this.doctypeSystem != null) {
            message.append("[ Doctype:  ");
            if (this.doctypePublic != null) {
                message.append(this.doctypePublic);
                message.append(" ");
            }
            message.append(this.doctypeSystem);
            message.append(" ]<br>");
        }
        if (this.preserveSpace != null) {
            message.append("[ Preserve Space:  ");
            message.append(this.preserveSpace);
            message.append(" ]<br>");
        }
        if (this.indent != null) {
            message.append("[ Indent:  ");
            message.append(this.indent);
            message.append(" ]<br>");
        }
        if (this.lineWidth != null) {
            message.append("[ Line Width:  ");
            message.append(this.lineWidth);
            message.append(" ]<br>");
        }
        message.append("<br>");
        return message.toString();
    }

    public void init(Configurations conf) {
        String mt = (String)conf.get("MIME-type");
        if (mt != null) {
            this.MIMEtype = mt;
        }
        this.format = new OutputFormat();
        this.format.setPreserveSpace(true);
        this.encoding = (String)conf.get("encoding");
        if (this.encoding != null) {
            this.format.setEncoding(this.encoding);
        }
        this.doctypePublic = (String)conf.get("doctype-public");
        this.doctypeSystem = (String)conf.get("doctype-system");
        if (this.doctypeSystem != null) {
            this.format.setDoctype(this.doctypePublic, this.doctypeSystem);
        }
        this.indent = (String)conf.get("indent");
        if (this.indent != null) {
            this.format.setIndenting(true);
            this.format.setIndent(Integer.parseInt(this.indent));
        }
        this.preserveSpace = (String)conf.get("preserve-space");
        if (this.preserveSpace != null) {
            this.format.setPreserveSpace(Boolean.getBoolean(this.preserveSpace));
        }
        this.lineWidth = (String)conf.get("line-width");
        if (this.lineWidth != null) {
            this.format.setLineWidth(Integer.parseInt(this.lineWidth));
        }
    }
}

