/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Engine;
import org.apache.cocoon.EngineWrapper;
import org.apache.cocoon.Frontend;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.Configurations;

public class Cocoon
extends HttpServlet
implements Defaults {
    Engine engine = null;
    String message = null;
    Exception exception = null;
    Configurations confs = null;
    String confsName = null;
    String server = null;
    String statusURL = null;
    boolean errorsInternally = false;
    boolean showStatus = false;
    int containerMajorVersion;
    int containerMinorVersion;

    private int getContainerMajorVersion() {
        int v;
        try {
            v = this.getServletConfig().getServletContext().getMajorVersion();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            v = 2;
        }
        return v;
    }

    private int getContainerMinorVersion() {
        int v;
        try {
            v = this.getServletConfig().getServletContext().getMinorVersion();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            v = 0;
        }
        return v;
    }

    private static String getProperties(String file) throws Exception {
        File f;
        if (file != null && (f = new File(file)).canRead()) {
            return f.toString();
        }
        f = new File("cocoon.properties");
        if (f.canRead()) {
            return f.toString();
        }
        f = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "cocoon.properties");
        if (f.canRead()) {
            return f.toString();
        }
        f = new File("/usr/local/etc/cocoon.properties");
        if (f.canRead()) {
            return f.toString();
        }
        throw new Exception("The property file could not be found.");
    }

    public String getServletInfo() {
        return Cocoon.version();
    }

    private Hashtable getStatus() {
        Runtime jvm = Runtime.getRuntime();
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put("Servlet Engine", this.server);
        table.put("Configurations", this.confsName);
        table.put("Free Memory", new Long(jvm.freeMemory()));
        table.put("Total Memory", new Long(jvm.totalMemory()));
        return table;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.server = config.getServletContext().getServerInfo();
        this.confsName = config.getInitParameter("properties");
        this.containerMajorVersion = this.getContainerMajorVersion();
        this.containerMinorVersion = this.getContainerMinorVersion();
        if (this.confsName == null) {
            this.exception = null;
            this.message = "<p>The servlet initialization argument <i>\"properties\"</i> was not found. Please, make sure Cocoon is able to find its configurations or it won't be able to execute correctly.</p><p>A template for such configurations may be found in the file \"/conf/cocoon.properties\" in the distribution.</p>";
            return;
        }
        try {
            if (this.containerMajorVersion >= 2 && this.containerMinorVersion >= 2) {
                try {
                    URL resource = config.getServletContext().getResource(this.confsName);
                    InputStream confsStream = resource.openConnection().getInputStream();
                    this.confs = new Configurations(confsStream);
                    confsStream.close();
                }
                catch (Exception ex) {
                    this.exception = ex;
                    this.message = "Unable to open resource: " + this.confsName;
                    return;
                }
            } else {
                this.confs = new Configurations(this.confsName);
            }
            this.showStatus = ((String)this.confs.get("selfservlet.enabled", "false")).toLowerCase().equals("true");
            this.statusURL = (String)this.confs.get("selfservlet.uri", "/Cocoon.xml");
            this.errorsInternally = ((String)this.confs.get("handle.errors.internally", "false")).toLowerCase().equals("true");
            this.engine = Engine.getInstance(this.confs, this.getServletConfig().getServletContext());
        }
        catch (Exception e) {
            this.exception = e;
            this.message = "Publishing Engine could not be initialized.";
        }
    }

    public static void main(String[] argument) throws Exception {
        String properties = null;
        String xml = null;
        Object xsl = null;
        String out = null;
        int i = 0;
        if (argument.length < 2 || argument.length > 4) {
            Cocoon.usage();
        }
        if (argument[i].charAt(0) == '-') {
            properties = Cocoon.getProperties(argument[++i]);
        }
        int n = ++i;
        xml = argument[n];
        out = argument[++i];
        EngineWrapper engine = new EngineWrapper(new Configurations(properties));
        engine.handle(new PrintWriter((Writer)new FileWriter(out), true), new File(xml));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            if (this.engine == null) {
                Frontend.error((ServletResponse)response, this.message, this.exception);
            } else if (this.showStatus && request.getRequestURI().endsWith(this.statusURL)) {
                Frontend.status((ServletResponse)response, this.getStatus(), this.engine.getStatus());
            } else {
                try {
                    this.engine.handle(request, response);
                }
                catch (FileNotFoundException e) {
                    if (this.errorsInternally) {
                        Frontend.error((ServletResponse)response, "File not found.", e);
                        break block9;
                    }
                    response.sendError(404, Utils.getStackTraceAsString(e));
                }
                catch (Throwable t) {
                    if (this.errorsInternally) {
                        Frontend.error((ServletResponse)response, "Error found handling the request.", t);
                        break block9;
                    }
                    response.sendError(500, Utils.getStackTraceAsString(t));
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.cocoon.Cocoon [-p properties] Input Output");
        System.err.println("\nOptions:");
        System.err.println("  -p : indicates the property file");
        System.err.println("\nNote: if the property file is not specified, Cocoon looks for a file named");
        System.err.println("\"cocoon.properties\" in the current working directory, in the user directory");
        System.err.println("and in the \"/usr/local/etc/\" directory before giving up.");
        System.exit(1);
    }

    public static String version() {
        return "Cocoon 1.8";
    }
}

