/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.FontState;

public class TableColumn
extends FObj {
    FontState fs;
    ColorType backgroundColor;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    int columnWidth;
    int columnOffset;
    AreaContainer areaContainer;

    public TableColumn(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-column";
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public Status layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            String string = this.properties.get("font-family").getString();
            String string2 = this.properties.get("font-style").getString();
            String string3 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), string, string2, string3, n);
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
            this.columnWidth = this.properties.get("column-width").getLength().mvalue();
        }
        this.areaContainer = new AreaContainer(this.fs, this.columnOffset - area.borderWidthLeft, -area.borderWidthTop, this.columnWidth, area.getHeight(), 2);
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.setHeight(area.getHeight());
        area.addChild(this.areaContainer);
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void setColumnOffset(int n) {
        this.columnOffset = n;
    }

    public void setHeight(int n) {
        this.areaContainer.setMaxHeight(n);
        this.areaContainer.setHeight(n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableColumn(fObj, propertyList);
        }
    }
}

