/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class DisplayGraphic
extends FObj {
    FontState fs;
    int align;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    String href;
    int height;
    int width;
    ImageArea imageArea;

    public DisplayGraphic(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:display-graphic";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1000) {
            object = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object, string, string2, n);
            this.align = this.properties.get("text-align").getEnum();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.href = this.properties.get("href").getString();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.isInLabel) {
                this.startIndent += this.bodyIndent;
                this.endIndent += area.getAllocationWidth() - this.distanceBetweenStarts - this.startIndent + this.labelSeparation;
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
            }
            if (this.isInTableCell) {
                this.startIndent += this.forcedStartOffset;
                this.endIndent = area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        object = FopImageFactory.Make(this.href, 0, 0, this.width, this.height);
        this.imageArea = new ImageArea(this.fs, (FopImage)object, area.getAllocationWidth(), object.getWidth(), object.getHeight(), this.startIndent, this.endIndent, this.align);
        this.imageArea.start();
        this.imageArea.end();
        area.addChild(this.imageArea);
        area.increaseHeight(this.imageArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new DisplayGraphic(fObj, propertyList);
        }
    }
}

