/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.BackgroundColor;
import org.apache.fop.fo.properties.BorderAfterColor;
import org.apache.fop.fo.properties.BorderAfterStyle;
import org.apache.fop.fo.properties.BorderAfterWidth;
import org.apache.fop.fo.properties.BorderBeforeColor;
import org.apache.fop.fo.properties.BorderBeforeStyle;
import org.apache.fop.fo.properties.BorderBeforeWidth;
import org.apache.fop.fo.properties.BorderBottom;
import org.apache.fop.fo.properties.BorderBottomColor;
import org.apache.fop.fo.properties.BorderBottomStyle;
import org.apache.fop.fo.properties.BorderBottomWidth;
import org.apache.fop.fo.properties.BorderColor;
import org.apache.fop.fo.properties.BorderEndColor;
import org.apache.fop.fo.properties.BorderEndStyle;
import org.apache.fop.fo.properties.BorderEndWidth;
import org.apache.fop.fo.properties.BorderLeft;
import org.apache.fop.fo.properties.BorderLeftColor;
import org.apache.fop.fo.properties.BorderLeftStyle;
import org.apache.fop.fo.properties.BorderLeftWidth;
import org.apache.fop.fo.properties.BorderRight;
import org.apache.fop.fo.properties.BorderRightColor;
import org.apache.fop.fo.properties.BorderRightStyle;
import org.apache.fop.fo.properties.BorderRightWidth;
import org.apache.fop.fo.properties.BorderStartColor;
import org.apache.fop.fo.properties.BorderStartWidth;
import org.apache.fop.fo.properties.BorderStyle;
import org.apache.fop.fo.properties.BorderTop;
import org.apache.fop.fo.properties.BorderTopColor;
import org.apache.fop.fo.properties.BorderTopStyle;
import org.apache.fop.fo.properties.BorderWidth;
import org.apache.fop.fo.properties.Bottom;
import org.apache.fop.fo.properties.BreakAfter;
import org.apache.fop.fo.properties.BreakBefore;
import org.apache.fop.fo.properties.Color;
import org.apache.fop.fo.properties.ColumnWidth;
import org.apache.fop.fo.properties.EndIndent;
import org.apache.fop.fo.properties.Extent;
import org.apache.fop.fo.properties.ExternalDestination;
import org.apache.fop.fo.properties.FlowName;
import org.apache.fop.fo.properties.FontFamily;
import org.apache.fop.fo.properties.FontSize;
import org.apache.fop.fo.properties.FontStyle;
import org.apache.fop.fo.properties.FontWeight;
import org.apache.fop.fo.properties.HRef;
import org.apache.fop.fo.properties.Height;
import org.apache.fop.fo.properties.InitialPageNumber;
import org.apache.fop.fo.properties.KeepWithNext;
import org.apache.fop.fo.properties.Left;
import org.apache.fop.fo.properties.LineHeight;
import org.apache.fop.fo.properties.MarginBottom;
import org.apache.fop.fo.properties.MarginLeft;
import org.apache.fop.fo.properties.MarginRight;
import org.apache.fop.fo.properties.MarginTop;
import org.apache.fop.fo.properties.Padding;
import org.apache.fop.fo.properties.PaddingAfter;
import org.apache.fop.fo.properties.PaddingBefore;
import org.apache.fop.fo.properties.PaddingBottom;
import org.apache.fop.fo.properties.PaddingEnd;
import org.apache.fop.fo.properties.PaddingLeft;
import org.apache.fop.fo.properties.PaddingRight;
import org.apache.fop.fo.properties.PaddingStart;
import org.apache.fop.fo.properties.PaddingTop;
import org.apache.fop.fo.properties.PageHeight;
import org.apache.fop.fo.properties.PageMasterEven;
import org.apache.fop.fo.properties.PageMasterFirst;
import org.apache.fop.fo.properties.PageMasterName;
import org.apache.fop.fo.properties.PageMasterOdd;
import org.apache.fop.fo.properties.PageMasterRepeating;
import org.apache.fop.fo.properties.PageWidth;
import org.apache.fop.fo.properties.Position;
import org.apache.fop.fo.properties.ProvisionalDistanceBetweenStarts;
import org.apache.fop.fo.properties.ProvisionalLabelSeparation;
import org.apache.fop.fo.properties.Right;
import org.apache.fop.fo.properties.RuleThickness;
import org.apache.fop.fo.properties.SpaceAfterOptimum;
import org.apache.fop.fo.properties.SpaceBeforeOptimum;
import org.apache.fop.fo.properties.StartIndent;
import org.apache.fop.fo.properties.TextAlign;
import org.apache.fop.fo.properties.TextAlignLast;
import org.apache.fop.fo.properties.TextIndent;
import org.apache.fop.fo.properties.Top;
import org.apache.fop.fo.properties.WhiteSpaceTreatment;
import org.apache.fop.fo.properties.Width;
import org.apache.fop.fo.properties.WrapOption;
import org.apache.fop.svg.SVGLength;
import org.xml.sax.AttributeList;

public class PropertyListBuilder {
    private Hashtable propertyTable = new Hashtable();

    public PropertyListBuilder() {
        this.propertyTable.put("end-indent", EndIndent.maker());
        this.propertyTable.put("page-master-name", PageMasterName.maker());
        this.propertyTable.put("page-master-first", PageMasterFirst.maker());
        this.propertyTable.put("page-master-repeating", PageMasterRepeating.maker());
        this.propertyTable.put("page-master-odd", PageMasterOdd.maker());
        this.propertyTable.put("page-master-even", PageMasterEven.maker());
        this.propertyTable.put("margin-top", MarginTop.maker());
        this.propertyTable.put("margin-bottom", MarginBottom.maker());
        this.propertyTable.put("margin-left", MarginLeft.maker());
        this.propertyTable.put("margin-right", MarginRight.maker());
        this.propertyTable.put("extent", Extent.maker());
        this.propertyTable.put("page-width", PageWidth.maker());
        this.propertyTable.put("page-height", PageHeight.maker());
        this.propertyTable.put("flow-name", FlowName.maker());
        this.propertyTable.put("font-family", FontFamily.maker());
        this.propertyTable.put("font-style", FontStyle.maker());
        this.propertyTable.put("font-weight", FontWeight.maker());
        this.propertyTable.put("font-size", FontSize.maker());
        this.propertyTable.put("line-height", LineHeight.maker());
        this.propertyTable.put("text-align", TextAlign.maker());
        this.propertyTable.put("text-align-last", TextAlignLast.maker());
        this.propertyTable.put("space-before.optimum", SpaceBeforeOptimum.maker());
        this.propertyTable.put("space-after.optimum", SpaceAfterOptimum.maker());
        this.propertyTable.put("start-indent", StartIndent.maker());
        this.propertyTable.put("end-indent", EndIndent.maker());
        this.propertyTable.put("provisional-distance-between-starts", ProvisionalDistanceBetweenStarts.maker());
        this.propertyTable.put("provisional-label-separation", ProvisionalLabelSeparation.maker());
        this.propertyTable.put("rule-thickness", RuleThickness.maker());
        this.propertyTable.put("color", Color.maker());
        this.propertyTable.put("wrap-option", WrapOption.maker());
        this.propertyTable.put("white-space-treatment", WhiteSpaceTreatment.maker());
        this.propertyTable.put("break-before", BreakBefore.maker());
        this.propertyTable.put("break-after", BreakAfter.maker());
        this.propertyTable.put("text-indent", TextIndent.maker());
        this.propertyTable.put("href", HRef.maker());
        this.propertyTable.put("column-width", ColumnWidth.maker());
        this.propertyTable.put("keep-with-next", KeepWithNext.maker());
        this.propertyTable.put("background-color", BackgroundColor.maker());
        this.propertyTable.put("padding-top", PaddingTop.maker());
        this.propertyTable.put("padding-bottom", PaddingBottom.maker());
        this.propertyTable.put("padding-left", PaddingLeft.maker());
        this.propertyTable.put("padding-right", PaddingRight.maker());
        this.propertyTable.put("external-destination", ExternalDestination.maker());
        this.propertyTable.put("height", SVGLength.maker());
        this.propertyTable.put("width", SVGLength.maker());
        this.propertyTable.put("x", SVGLength.maker());
        this.propertyTable.put("y", SVGLength.maker());
        this.propertyTable.put("x1", SVGLength.maker());
        this.propertyTable.put("x2", SVGLength.maker());
        this.propertyTable.put("y1", SVGLength.maker());
        this.propertyTable.put("y2", SVGLength.maker());
        this.propertyTable.put("border-after-color", BorderAfterColor.maker());
        this.propertyTable.put("border-after-style", BorderAfterStyle.maker());
        this.propertyTable.put("border-after-width", BorderAfterWidth.maker());
        this.propertyTable.put("border-before-color", BorderBeforeColor.maker());
        this.propertyTable.put("border-before-style", BorderBeforeStyle.maker());
        this.propertyTable.put("border-before-width", BorderBeforeWidth.maker());
        this.propertyTable.put("border-bottom", BorderBottom.maker());
        this.propertyTable.put("border-bottom-color", BorderBottomColor.maker());
        this.propertyTable.put("border-bottom-style", BorderBottomStyle.maker());
        this.propertyTable.put("border-bottom-width", BorderBottomWidth.maker());
        this.propertyTable.put("border-color", BorderColor.maker());
        this.propertyTable.put("border-end-color", BorderEndColor.maker());
        this.propertyTable.put("border-end-style", BorderEndStyle.maker());
        this.propertyTable.put("border-end-width", BorderEndWidth.maker());
        this.propertyTable.put("border-left", BorderLeft.maker());
        this.propertyTable.put("border-left-color", BorderLeftColor.maker());
        this.propertyTable.put("border-left-style", BorderLeftStyle.maker());
        this.propertyTable.put("border-left-width", BorderLeftWidth.maker());
        this.propertyTable.put("border-right", BorderRight.maker());
        this.propertyTable.put("border-right-color", BorderRightColor.maker());
        this.propertyTable.put("border-right-style", BorderRightStyle.maker());
        this.propertyTable.put("border-right-width", BorderRightWidth.maker());
        this.propertyTable.put("border-start-color", BorderStartColor.maker());
        this.propertyTable.put("border-start-color", BorderStartColor.maker());
        this.propertyTable.put("border-start-width", BorderStartWidth.maker());
        this.propertyTable.put("border-style", BorderStyle.maker());
        this.propertyTable.put("border-top", BorderTop.maker());
        this.propertyTable.put("border-top-color", BorderTopColor.maker());
        this.propertyTable.put("border-top-style", BorderTopStyle.maker());
        this.propertyTable.put("border-top-style", BorderTopStyle.maker());
        this.propertyTable.put("border-width", BorderWidth.maker());
        this.propertyTable.put("bottom", Bottom.maker());
        this.propertyTable.put("height", Height.maker());
        this.propertyTable.put("left", Left.maker());
        this.propertyTable.put("padding", Padding.maker());
        this.propertyTable.put("padding-after", PaddingAfter.maker());
        this.propertyTable.put("padding-before", PaddingBefore.maker());
        this.propertyTable.put("padding-end", PaddingEnd.maker());
        this.propertyTable.put("padding-start", PaddingStart.maker());
        this.propertyTable.put("position", Position.maker());
        this.propertyTable.put("right", Right.maker());
        this.propertyTable.put("top", Top.maker());
        this.propertyTable.put("width", Width.maker());
        this.propertyTable.put("initial-page-number", InitialPageNumber.maker());
    }

    public Property computeProperty(PropertyList propertyList, String string) {
        Property property = null;
        Property.Maker maker = (Property.Maker)this.propertyTable.get(string);
        if (maker != null) {
            property = maker.compute(propertyList);
        } else {
            System.err.println("WARNING: property " + string + " ignored");
        }
        return property;
    }

    public boolean isInherited(String string) {
        Property.Maker maker = (Property.Maker)this.propertyTable.get(string);
        boolean bl = maker != null ? maker.isInherited() : true;
        return bl;
    }

    public PropertyList makeList(AttributeList attributeList, PropertyList propertyList) throws FOPException {
        PropertyList propertyList2 = new PropertyList(propertyList);
        propertyList2.setBuilder(this);
        int n = 0;
        while (n < attributeList.getLength()) {
            String string = attributeList.getName(n);
            Property.Maker maker = (Property.Maker)this.propertyTable.get(string);
            if (maker != null) {
                propertyList2.put(string, maker.make(propertyList2, attributeList.getValue(n)));
            }
            ++n;
        }
        return propertyList2;
    }

    public Property makeProperty(PropertyList propertyList, String string) throws FOPException {
        Property property = null;
        Property.Maker maker = (Property.Maker)this.propertyTable.get(string);
        if (maker != null) {
            property = maker.make(propertyList);
        } else {
            System.err.println("WARNING: property " + string + " ignored");
        }
        return property;
    }
}

