
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.component;

import java.awt.*;

/**
 * Contains a piece of data along with a variety of associated attributes.
 * Any of these attributes may be <tt>null</tt>, in which case they will
 * be ignored.
 * This class can be used in conjunction with various cell renderers and
 * editors.
 */
public class FancyData {
    /**
     * The piece of data stored.
     */
    public Object data;
    /**
     * The foreground colour with which to draw the data.
     */
    public Color fgColor;
    /**
     * A tooltip associated with the data.
     */
    public String toolTip;

    /**
     * Creates a new object with the given attributes.
     *
     * @param data the piece data to store.
     * @param fgColor the foreground colour with which to draw the data.
     * @param toolTip a tooltip associated with the data.
     */
    public FancyData(Object data, Color fgColor, String toolTip) {
        this.data = data;
        this.fgColor = fgColor;
        this.toolTip = toolTip;
    }

    /**
     * Creates a new object with the given attributes.
     *
     * @param data the piece data to store.
     * @param fgColor the foreground colour with which to draw the data.
     */
    public FancyData(Object data, Color fgColor) {
        this.data = data;
        this.fgColor = fgColor;
        this.toolTip = null;
    }

    /**
     * Creates a new object with the given attributes.
     *
     * @param data the piece data to store.
     * @param toolTip a tooltip associated with the data.
     */
    public FancyData(Object data, String toolTip) {
        this.data = data;
        this.fgColor = null;
        this.toolTip = toolTip;
    }
}
