
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.gui.component;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * An enhanced table cell renderer.
 * This renderer may be shared amongst cells.
 * <p>
 * If a cell contains an object of type <tt>FancyData</tt>,
 * the attributes in the <tt>FancyData</tt> object will be used to
 * render the data stored in <tt>FancyData.data</tt>.  Otherwise the
 * cell contents will be displayed in the default fashion.
 *
 * @see FancyData
 */
public class FancyCellRenderer extends DefaultTableCellRenderer {
    /**
     * Creates a new renderer.
     */
    public FancyCellRenderer() {
        super();
    }

    /**
     * Returns the component that does the rendering.
     *
     * @param table the table in which a cell is being rendered.
     * @param value the value of the table cell being rendered.
     * @param isSelected whether or not the table cell is currently
     * selected.
     * @param hasFocus whether or not the table cell currently has the
     * focus.
     * @param row the row of the table cell being rendered.
     * @param column the column of the table cell being rendered.
     * @return the component that does the rendering.
     */
    public Component getTableCellRendererComponent(JTable table,
            Object value, boolean isSelected, boolean hasFocus,
            int row, int column) {
        FancyData data = (value instanceof FancyData ?
            (FancyData)value : null);
        Component ans = super.getTableCellRendererComponent(table,
            data == null ? value : data.data, isSelected, hasFocus,
            row, column);
        if (data == null)
            return ans;
        
        if (ans instanceof JComponent) {
            JComponent real = (JComponent)ans;

            // Set the tooltip.
            if (data.toolTip != null)
                real.setToolTipText(data.toolTip);
        }

        // Set the foreground colour.
        if (data.fgColor != null)
            ans.setForeground(data.fgColor);

        return ans;
    }
}

