/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHArrayDimensions;
import bsh.BSHBlock;
import bsh.BSHPrimitiveType;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

class BSHAllocationExpression
extends SimpleNode {
    BSHAllocationExpression(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        SimpleNode simpleNode2 = (SimpleNode)this.jjtGetChild(1);
        if (simpleNode instanceof BSHAmbiguousName) {
            BSHAmbiguousName bSHAmbiguousName = (BSHAmbiguousName)simpleNode;
            if (simpleNode2 instanceof BSHArguments) {
                return this.objectAllocation(bSHAmbiguousName, (BSHArguments)simpleNode2, nameSpace, interpreter);
            }
            return this.objectArrayAllocation(bSHAmbiguousName, (BSHArrayDimensions)simpleNode2, nameSpace, interpreter);
        }
        return this.primitiveArrayAllocation((BSHPrimitiveType)simpleNode, (BSHArrayDimensions)simpleNode2, nameSpace, interpreter);
    }

    private Object objectAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArguments bSHArguments, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        boolean bl;
        Class clazz = bSHAmbiguousName.toClass(nameSpace);
        Object[] objectArray = bSHArguments.getArguments(nameSpace, interpreter);
        if (objectArray == null) {
            throw new EvalError("Trying to new a class...?", this);
        }
        boolean bl2 = bl = this.jjtGetNumChildren() > 2;
        if (bl) {
            BSHBlock bSHBlock = (BSHBlock)this.jjtGetChild(2);
            return this.constructWithBody(clazz, objectArray, bSHBlock, nameSpace, interpreter);
        }
        return this.constructObject(clazz, objectArray);
    }

    private Object constructObject(Class clazz, Object[] objectArray) throws EvalError {
        try {
            return Reflect.constructObject(clazz, objectArray);
        }
        catch (ReflectError reflectError) {
            throw new EvalError("Constructor error: " + reflectError.getMessage(), this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Interpreter.debug("The constructor threw an exception:\n\t" + invocationTargetException.getTargetException());
            throw new TargetError(invocationTargetException.getTargetException(), (SimpleNode)this);
        }
    }

    private Object constructWithBody(Class clazz, Object[] objectArray, BSHBlock bSHBlock, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        if (!clazz.isInterface()) {
            throw new EvalError("BeanShell cannot extend class types: " + clazz);
        }
        NameSpace nameSpace2 = new NameSpace(nameSpace, "anonymous block object");
        bSHBlock.eval(nameSpace2, interpreter);
        return nameSpace2.getThis(interpreter).getInterface(clazz);
    }

    private Object objectArrayAllocation(BSHAmbiguousName bSHAmbiguousName, BSHArrayDimensions bSHArrayDimensions, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Class clazz = bSHAmbiguousName.toClass(nameSpace);
        if (clazz == null) {
            throw new EvalError("Class " + bSHAmbiguousName.getName(nameSpace) + " not found.", this);
        }
        Object object = bSHArrayDimensions.eval(clazz, nameSpace, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        try {
            return Array.newInstance(clazz, bSHArrayDimensions.dimensions);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct array: " + exception.getMessage(), this);
        }
    }

    private Object primitiveArrayAllocation(BSHPrimitiveType bSHPrimitiveType, BSHArrayDimensions bSHArrayDimensions, NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Class clazz = bSHPrimitiveType.getType();
        Object object = bSHArrayDimensions.eval(clazz, nameSpace, interpreter);
        if (object != Primitive.VOID) {
            return object;
        }
        try {
            return Array.newInstance(clazz, bSHArrayDimensions.dimensions);
        }
        catch (Exception exception) {
            throw new EvalError("Can't construct primitive array: " + exception.getMessage(), this);
        }
    }
}

