/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "lo" locale.
 */
public class LocalizedNamesImpl_lo extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "LA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AG",
        "AQ",
        "AS",
        "AX",
        "BL",
        "BV",
        "CC",
        "CD",
        "CK",
        "CP",
        "CX",
        "DG",
        "EA",
        "EU",
        "FK",
        "FO",
        "GD",
        "GG",
        "GI",
        "GL",
        "GS",
        "GU",
        "HM",
        "IC",
        "IM",
        "IO",
        "JE",
        "KN",
        "KY",
        "LC",
        "ME",
        "MF",
        "MH",
        "MP",
        "MV",
        "MW",
        "NF",
        "NR",
        "PM",
        "PN",
        "PS",
        "PW",
        "QO",
        "RE",
        "RS",
        "SB",
        "SH",
        "SJ",
        "SM",
        "ST",
        "TA",
        "TC",
        "TV",
        "UM",
        "VC",
        "WF",
        "WS",
        "QA",
        "CA",
        "GH",
        "GA",
        "KH",
        "GN",
        "GW",
        "GR",
        "GY",
        "GP",
        "GT",
        "CG",
        "CR",
        "KZ",
        "CM",
        "CU",
        "DJ",
        "KI",
        "KW",
        "JM",
        "CN",
        "GE",
        "JO",
        "TD",
        "SA",
        "EH",
        "SN",
        "ZW",
        "CL",
        "SY",
        "SD",
        "SR",
        "JP",
        "TO",
        "TL",
        "TR",
        "TN",
        "TJ",
        "TZ",
        "TT",
        "NA",
        "NI",
        "NC",
        "NZ",
        "NU",
        "NO",
        "VG",
        "BW",
        "BD",
        "BG",
        "BA",
        "BB",
        "BS",
        "BH",
        "BI",
        "BN",
        "BR",
        "TH",
        "PK",
        "PA",
        "PG",
        "PY",
        "FR",
        "CI",
        "BT",
        "FJ",
        "FI",
        "PH",
        "MS",
        "MT",
        "MG",
        "MQ",
        "YT",
        "ML",
        "MO",
        "MY",
        "MN",
        "MU",
        "MR",
        "UA",
        "VI",
        "RU",
        "LA",
        "RW",
        "LT",
        "LY",
        "LR",
        "LU",
        "UY",
        "RO",
        "LV",
        "VA",
        "VU",
        "SZ",
        "CH",
        "SE",
        "MM",
        "AE",
        "US",
        "GB",
        "ES",
        "SK",
        "SI",
        "CF",
        "CZ",
        "DO",
        "SG",
        "LK",
        "VN",
        "HN",
        "AI",
        "AD",
        "AO",
        "AF",
        "TF",
        "ZA",
        "AM",
        "AW",
        "AR",
        "AZ",
        "IT",
        "ER",
        "IN",
        "ID",
        "IL",
        "EG",
        "IQ",
        "IR",
        "UZ",
        "UG",
        "AU",
        "AT",
        "HU",
        "HK",
        "KP",
        "KR",
        "KE",
        "CV",
        "SL",
        "CS",
        "SC",
        "DK",
        "KG",
        "TM",
        "NP",
        "NL",
        "AN",
        "BY",
        "BJ",
        "BZ",
        "BE",
        "BF",
        "BM",
        "PE",
        "PR",
        "PF",
        "GF",
        "DE",
        "YE",
        "LB",
        "LS",
        "VE",
        "EC",
        "GQ",
        "SV",
        "ET",
        "EE",
        "GM",
        "ZM",
        "MK",
        "MX",
        "DZ",
        "AL",
        "CO",
        "HR",
        "KM",
        "SO",
        "DM",
        "TG",
        "TK",
        "BO",
        "PT",
        "PL",
        "MC",
        "MD",
        "MA",
        "MZ",
        "OM",
        "CY",
        "TW",
        "NG",
        "NE",
        "FM",
        "LI",
        "HT",
        "IS",
        "IE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "ອັນດໍລາ");
    namesMap.put("AE", "ສະຫະລັດອາຫລັບເອມິເລດ");
    namesMap.put("AF", "ອັຟການິດສະຖານ");
    namesMap.put("AI", "ອັນກິລາ");
    namesMap.put("AL", "ແອລເບເນຍ");
    namesMap.put("AM", "ອາມິເນຍ");
    namesMap.put("AN", "ເນເທີແລນແອນເທິນ");
    namesMap.put("AO", "ອັນໂກລາ");
    namesMap.put("AR", "ອາເຈນຕິນາ່");
    namesMap.put("AT", "ອົອດສະເຕຼຍ");
    namesMap.put("AU", "ອົອດສະຕາລີ");
    namesMap.put("AW", "ອາລູບາ");
    namesMap.put("AZ", "ອາເຊີໄບຈັນ");
    namesMap.put("BA", "ບັອດສເນຍ ແລະ ເຮີດໂກວິເນຍ");
    namesMap.put("BB", "ບາບາຄັອດ");
    namesMap.put("BD", "ບັງກະລາເທດ");
    namesMap.put("BE", "ເບວຢຽມ");
    namesMap.put("BF", "ເບີກິນາຟາໂຊ");
    namesMap.put("BG", "ບັງກາເລຍ");
    namesMap.put("BH", "ບາເລນ");
    namesMap.put("BI", "ບູລັນຕິ");
    namesMap.put("BJ", "ເບນິນ");
    namesMap.put("BM", "ເບີມິວດາ");
    namesMap.put("BN", "ບູຮໄນ");
    namesMap.put("BO", "ໂບລິເວຍ");
    namesMap.put("BR", "ບຼາຊິວ");
    namesMap.put("BS", "ບາຮາມາສ");
    namesMap.put("BT", "ພູຖານ");
    namesMap.put("BW", "ບອັດສະວານາ");
    namesMap.put("BY", "ເບນລາຮັສ");
    namesMap.put("BZ", "ເບລິຊ");
    namesMap.put("CA", "ການາດາ");
    namesMap.put("CF", "ສາທາລະນະລັດອັບຟຼິກກາກາງ");
    namesMap.put("CG", "ຄອງໂກ");
    namesMap.put("CH", "ສະວິດເຊີແລນ");
    namesMap.put("CI", "ຝັ່ງທະເລໄອວໍລິ");
    namesMap.put("CL", "ຊິສິ");
    namesMap.put("CM", "ຄາເມລູນ");
    namesMap.put("CN", "ຈີນ");
    namesMap.put("CO", "ໂຄລຳເບຍ");
    namesMap.put("CR", "ຄອສຕາລິກາ");
    namesMap.put("CS", "ເຊີເບຍ");
    namesMap.put("CU", "ຄິວບາ");
    namesMap.put("CV", "ເຄບວອດ");
    namesMap.put("CY", "ໄຊປັຼດ");
    namesMap.put("CZ", "ສາທາລະນະລັດເຊັກ");
    namesMap.put("DE", "ເຢຍລະມັນ");
    namesMap.put("DJ", "ຄິໂບຕິ");
    namesMap.put("DK", "ເດນມາກ");
    namesMap.put("DM", "ໂດເມນິກາ");
    namesMap.put("DO", "ສາທາລະນະລັດໂດມິນິກັນ");
    namesMap.put("DZ", "ແອລຈິເລຍ");
    namesMap.put("EC", "ເອກວາດໍ");
    namesMap.put("EE", "ເອສໂຕເນຍ");
    namesMap.put("EG", "ອີຢິບ");
    namesMap.put("EH", "ຊາຮາລາຕະເວັນຕົກ");
    namesMap.put("ER", "ອິນຊີ");
    namesMap.put("ES", "ສະເປນ");
    namesMap.put("ET", "ເອທິໂອເປຍ");
    namesMap.put("FI", "ຟິນແລນ");
    namesMap.put("FJ", "ຟິຈິ");
    namesMap.put("FM", "ໄມໂຄນິເຊຍ");
    namesMap.put("FR", "ຝລັ່ງ");
    namesMap.put("GA", "ກາບອນ");
    namesMap.put("GB", "ສະຫະລາດຊະອານາຈັກ");
    namesMap.put("GE", "ຈໍເຈຍ");
    namesMap.put("GF", "ເຟັນສກິວນາ");
    namesMap.put("GH", "ການ່າ");
    namesMap.put("GM", "ແກມເບຍ");
    namesMap.put("GN", "ກິວນີ");
    namesMap.put("GP", "ກົວເດີລູບ");
    namesMap.put("GQ", "ເອຄົວໂທເລຍລະກິນີ");
    namesMap.put("GR", "ກິຼກ");
    namesMap.put("GT", "ກົວເຕມາລາ");
    namesMap.put("GW", "ກິວນີ-ບິສໂຊ");
    namesMap.put("GY", "ກູຢານາ");
    namesMap.put("HK", "ຮ່ອງກົງ");
    namesMap.put("HN", "ອວນຄູຣັສ");
    namesMap.put("HR", "ໂຄເອເຊຍ");
    namesMap.put("HT", "ໄອທີ");
    namesMap.put("HU", "ຮົງກາຣີ");
    namesMap.put("ID", "ອິນໂດເນເຊຍ");
    namesMap.put("IE", "ໄອແລນ");
    namesMap.put("IL", "ອິສລະເອວ");
    namesMap.put("IN", "ອິນເດຍ");
    namesMap.put("IQ", "ອີລັກ");
    namesMap.put("IR", "ອີລ່ານ");
    namesMap.put("IS", "ໄອສແລນ");
    namesMap.put("IT", "ອິຕາລີ");
    namesMap.put("JM", "ຈາໄມກາ");
    namesMap.put("JO", "ຈໍແດນ");
    namesMap.put("JP", "ຍີ່ປຸ່ນ");
    namesMap.put("KE", "ເຄນຢ່າ");
    namesMap.put("KG", "ເດີກິດສະຖານ");
    namesMap.put("KH", "ກຳປູເຈຍ");
    namesMap.put("KI", "ຄີລິບາດ");
    namesMap.put("KM", "ໂຄໂມຣອດ");
    namesMap.put("KP", "ເກົາຫລີເໜືອ");
    namesMap.put("KR", "ເກົາຫລີໃຕ້");
    namesMap.put("KW", "ຄູເວດ");
    namesMap.put("KZ", "ຄາຊັດສະຖານ");
    namesMap.put("LA", "ລາວ");
    namesMap.put("LB", "ເລບານອນ");
    namesMap.put("LI", "ໄລເທນສະໄຕ");
    namesMap.put("LK", "ສີລັງກາ");
    namesMap.put("LR", "ລິເບີເລຍ");
    namesMap.put("LS", "ເລໂຊໂທ");
    namesMap.put("LT", "ລິເທີເນຍ");
    namesMap.put("LU", "ລຸກແຊມເບີກ");
    namesMap.put("LV", "ລຼາດເວຍ");
    namesMap.put("LY", "ລິເບຍ");
    namesMap.put("MA", "ໂມລັອກໂຄ");
    namesMap.put("MC", "ໂມນາໂກ");
    namesMap.put("MD", "ໂມນໂຄວາ");
    namesMap.put("MG", "ມາຄາກັສກາ");
    namesMap.put("MK", "ແມຊິໂຄເນຍ");
    namesMap.put("ML", "ມາລິ");
    namesMap.put("MM", "ສະຫະພາບພະມ້າ");
    namesMap.put("MN", "ມົງໂກລີ");
    namesMap.put("MO", "ມາເກົ້າ");
    namesMap.put("MQ", "ມາຕິນິກ");
    namesMap.put("MR", "ມໍລິກທາເນຍ");
    namesMap.put("MS", "ມອນເຊີລາດ");
    namesMap.put("MT", "ມັນຕາ");
    namesMap.put("MU", "ມໍຣິຕຽດ");
    namesMap.put("MX", "ແມັກຊິໂກ");
    namesMap.put("MY", "ມາເລເຊຍ");
    namesMap.put("MZ", "ໂມແຊມບິກ");
    namesMap.put("NA", "ນາມິເບຍ");
    namesMap.put("NC", "ນິວຄາລິໂຄເນຍ");
    namesMap.put("NE", "ໄນເຈີ");
    namesMap.put("NG", "ໄນຈີເລຍ");
    namesMap.put("NI", "ນິຄາລາກົວ");
    namesMap.put("NL", "ເນເທີແລນ");
    namesMap.put("NO", "ນໍເວ");
    namesMap.put("NP", "ເນປານ");
    namesMap.put("NU", "ນີຢູ");
    namesMap.put("NZ", "ນິວຊີແລນ");
    namesMap.put("OM", "ໂອມານ");
    namesMap.put("PA", "ປານາມາ");
    namesMap.put("PE", "ເປລູ");
    namesMap.put("PF", "ເຟັນຣໂພລິນີເຊຍ");
    namesMap.put("PG", "ປາປົວນິວກີນີ");
    namesMap.put("PH", "ຟິລິປິນ");
    namesMap.put("PK", "ປາກິສຖານ");
    namesMap.put("PL", "ໂປແລນ");
    namesMap.put("PR", "ເປີໂຕລິໂກ");
    namesMap.put("PT", "ໂປຕຸກກັນ");
    namesMap.put("PY", "ປາລາກວຍ");
    namesMap.put("QA", "ກາຕາ");
    namesMap.put("RO", "ລູເມເນຍ");
    namesMap.put("RU", "ລັດເຊຍ");
    namesMap.put("RW", "ລາວັນດາ");
    namesMap.put("SA", "ຊາອຸດິອາລະເບຍ");
    namesMap.put("SC", "ເຊແຊວ");
    namesMap.put("SD", "ຊູດານ");
    namesMap.put("SE", "ສະວິເດັນ");
    namesMap.put("SG", "ສິງກະໂປ");
    namesMap.put("SI", "ສະໂລເວເນຍ");
    namesMap.put("SK", "ສະໂລວາເກຍ");
    namesMap.put("SL", "ເຊຍລາສິອອນ");
    namesMap.put("SN", "ຊິນີກັນ");
    namesMap.put("SO", "ໂຊມາເລຍ");
    namesMap.put("SR", "ຊູລິນາມິ");
    namesMap.put("SV", "ເອຊາວາດໍ");
    namesMap.put("SY", "ຊິເລຍ");
    namesMap.put("SZ", "ສະວາຊິແລນ");
    namesMap.put("TD", "ຊາດ");
    namesMap.put("TF", "ອານາເຂດທາງໃຕ້ຂອງຝລັ່ງເສດ");
    namesMap.put("TG", "ໂຕໂກ");
    namesMap.put("TH", "ປະເທດໄທ");
    namesMap.put("TJ", "ທາຈິກິສະຖານ");
    namesMap.put("TK", "ໂທກິໂລ");
    namesMap.put("TL", "ຕິມໍຕາເວັນອອກ");
    namesMap.put("TM", "ເຕຣີກເມນິສະຖານ");
    namesMap.put("TN", "ຕູນິເຊຍ");
    namesMap.put("TO", "ຕອງກາ");
    namesMap.put("TR", "ຕຸນກີ");
    namesMap.put("TT", "ທິນິແດດ");
    namesMap.put("TW", "ໄຕ້ຫວັນ");
    namesMap.put("TZ", "ທານຊາເນຍ");
    namesMap.put("UA", "ຢູເຄຼນ");
    namesMap.put("UG", "ອູການດາ");
    namesMap.put("US", "ສະຫະລັດອາເມລິກາ");
    namesMap.put("UY", "ລູກວຍອຸຣ");
    namesMap.put("UZ", "ອຸດເບກິສະຖານ");
    namesMap.put("VA", "ວາຕິກັນ");
    namesMap.put("VE", "ເວເນຊູເອລາ");
    namesMap.put("VG", "ບຣິທິດເວີຈິນໄອແລນ");
    namesMap.put("VI", "ຢູເອສເວີຈິນໄອແລນ");
    namesMap.put("VN", "ຫວຽດນາມ");
    namesMap.put("VU", "ວານົວຕູ");
    namesMap.put("YE", "ເຢເມນ");
    namesMap.put("YT", "ມາຢອດ");
    namesMap.put("ZA", "ອາຟະລິກາໃຕ້");
    namesMap.put("ZM", "ແຊມເບຍ");
    namesMap.put("ZW", "ຊິມບັບເວ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "ອັນດໍລາ",
        "AE": "ສະຫະລັດອາຫລັບເອມິເລດ",
        "AF": "ອັຟການິດສະຖານ",
        "AI": "ອັນກິລາ",
        "AL": "ແອລເບເນຍ",
        "AM": "ອາມິເນຍ",
        "AN": "ເນເທີແລນແອນເທິນ",
        "AO": "ອັນໂກລາ",
        "AR": "ອາເຈນຕິນາ່",
        "AT": "ອົອດສະເຕຼຍ",
        "AU": "ອົອດສະຕາລີ",
        "AW": "ອາລູບາ",
        "AZ": "ອາເຊີໄບຈັນ",
        "BA": "ບັອດສເນຍ ແລະ ເຮີດໂກວິເນຍ",
        "BB": "ບາບາຄັອດ",
        "BD": "ບັງກະລາເທດ",
        "BE": "ເບວຢຽມ",
        "BF": "ເບີກິນາຟາໂຊ",
        "BG": "ບັງກາເລຍ",
        "BH": "ບາເລນ",
        "BI": "ບູລັນຕິ",
        "BJ": "ເບນິນ",
        "BM": "ເບີມິວດາ",
        "BN": "ບູຮໄນ",
        "BO": "ໂບລິເວຍ",
        "BR": "ບຼາຊິວ",
        "BS": "ບາຮາມາສ",
        "BT": "ພູຖານ",
        "BW": "ບອັດສະວານາ",
        "BY": "ເບນລາຮັສ",
        "BZ": "ເບລິຊ",
        "CA": "ການາດາ",
        "CF": "ສາທາລະນະລັດອັບຟຼິກກາກາງ",
        "CG": "ຄອງໂກ",
        "CH": "ສະວິດເຊີແລນ",
        "CI": "ຝັ່ງທະເລໄອວໍລິ",
        "CL": "ຊິສິ",
        "CM": "ຄາເມລູນ",
        "CN": "ຈີນ",
        "CO": "ໂຄລຳເບຍ",
        "CR": "ຄອສຕາລິກາ",
        "CS": "ເຊີເບຍ",
        "CU": "ຄິວບາ",
        "CV": "ເຄບວອດ",
        "CY": "ໄຊປັຼດ",
        "CZ": "ສາທາລະນະລັດເຊັກ",
        "DE": "ເຢຍລະມັນ",
        "DJ": "ຄິໂບຕິ",
        "DK": "ເດນມາກ",
        "DM": "ໂດເມນິກາ",
        "DO": "ສາທາລະນະລັດໂດມິນິກັນ",
        "DZ": "ແອລຈິເລຍ",
        "EC": "ເອກວາດໍ",
        "EE": "ເອສໂຕເນຍ",
        "EG": "ອີຢິບ",
        "EH": "ຊາຮາລາຕະເວັນຕົກ",
        "ER": "ອິນຊີ",
        "ES": "ສະເປນ",
        "ET": "ເອທິໂອເປຍ",
        "FI": "ຟິນແລນ",
        "FJ": "ຟິຈິ",
        "FM": "ໄມໂຄນິເຊຍ",
        "FR": "ຝລັ່ງ",
        "GA": "ກາບອນ",
        "GB": "ສະຫະລາດຊະອານາຈັກ",
        "GE": "ຈໍເຈຍ",
        "GF": "ເຟັນສກິວນາ",
        "GH": "ການ່າ",
        "GM": "ແກມເບຍ",
        "GN": "ກິວນີ",
        "GP": "ກົວເດີລູບ",
        "GQ": "ເອຄົວໂທເລຍລະກິນີ",
        "GR": "ກິຼກ",
        "GT": "ກົວເຕມາລາ",
        "GW": "ກິວນີ-ບິສໂຊ",
        "GY": "ກູຢານາ",
        "HK": "ຮ່ອງກົງ",
        "HN": "ອວນຄູຣັສ",
        "HR": "ໂຄເອເຊຍ",
        "HT": "ໄອທີ",
        "HU": "ຮົງກາຣີ",
        "ID": "ອິນໂດເນເຊຍ",
        "IE": "ໄອແລນ",
        "IL": "ອິສລະເອວ",
        "IN": "ອິນເດຍ",
        "IQ": "ອີລັກ",
        "IR": "ອີລ່ານ",
        "IS": "ໄອສແລນ",
        "IT": "ອິຕາລີ",
        "JM": "ຈາໄມກາ",
        "JO": "ຈໍແດນ",
        "JP": "ຍີ່ປຸ່ນ",
        "KE": "ເຄນຢ່າ",
        "KG": "ເດີກິດສະຖານ",
        "KH": "ກຳປູເຈຍ",
        "KI": "ຄີລິບາດ",
        "KM": "ໂຄໂມຣອດ",
        "KP": "ເກົາຫລີເໜືອ",
        "KR": "ເກົາຫລີໃຕ້",
        "KW": "ຄູເວດ",
        "KZ": "ຄາຊັດສະຖານ",
        "LA": "ລາວ",
        "LB": "ເລບານອນ",
        "LI": "ໄລເທນສະໄຕ",
        "LK": "ສີລັງກາ",
        "LR": "ລິເບີເລຍ",
        "LS": "ເລໂຊໂທ",
        "LT": "ລິເທີເນຍ",
        "LU": "ລຸກແຊມເບີກ",
        "LV": "ລຼາດເວຍ",
        "LY": "ລິເບຍ",
        "MA": "ໂມລັອກໂຄ",
        "MC": "ໂມນາໂກ",
        "MD": "ໂມນໂຄວາ",
        "MG": "ມາຄາກັສກາ",
        "MK": "ແມຊິໂຄເນຍ",
        "ML": "ມາລິ",
        "MM": "ສະຫະພາບພະມ້າ",
        "MN": "ມົງໂກລີ",
        "MO": "ມາເກົ້າ",
        "MQ": "ມາຕິນິກ",
        "MR": "ມໍລິກທາເນຍ",
        "MS": "ມອນເຊີລາດ",
        "MT": "ມັນຕາ",
        "MU": "ມໍຣິຕຽດ",
        "MX": "ແມັກຊິໂກ",
        "MY": "ມາເລເຊຍ",
        "MZ": "ໂມແຊມບິກ",
        "NA": "ນາມິເບຍ",
        "NC": "ນິວຄາລິໂຄເນຍ",
        "NE": "ໄນເຈີ",
        "NG": "ໄນຈີເລຍ",
        "NI": "ນິຄາລາກົວ",
        "NL": "ເນເທີແລນ",
        "NO": "ນໍເວ",
        "NP": "ເນປານ",
        "NU": "ນີຢູ",
        "NZ": "ນິວຊີແລນ",
        "OM": "ໂອມານ",
        "PA": "ປານາມາ",
        "PE": "ເປລູ",
        "PF": "ເຟັນຣໂພລິນີເຊຍ",
        "PG": "ປາປົວນິວກີນີ",
        "PH": "ຟິລິປິນ",
        "PK": "ປາກິສຖານ",
        "PL": "ໂປແລນ",
        "PR": "ເປີໂຕລິໂກ",
        "PT": "ໂປຕຸກກັນ",
        "PY": "ປາລາກວຍ",
        "QA": "ກາຕາ",
        "RO": "ລູເມເນຍ",
        "RU": "ລັດເຊຍ",
        "RW": "ລາວັນດາ",
        "SA": "ຊາອຸດິອາລະເບຍ",
        "SC": "ເຊແຊວ",
        "SD": "ຊູດານ",
        "SE": "ສະວິເດັນ",
        "SG": "ສິງກະໂປ",
        "SI": "ສະໂລເວເນຍ",
        "SK": "ສະໂລວາເກຍ",
        "SL": "ເຊຍລາສິອອນ",
        "SN": "ຊິນີກັນ",
        "SO": "ໂຊມາເລຍ",
        "SR": "ຊູລິນາມິ",
        "SV": "ເອຊາວາດໍ",
        "SY": "ຊິເລຍ",
        "SZ": "ສະວາຊິແລນ",
        "TD": "ຊາດ",
        "TF": "ອານາເຂດທາງໃຕ້ຂອງຝລັ່ງເສດ",
        "TG": "ໂຕໂກ",
        "TH": "ປະເທດໄທ",
        "TJ": "ທາຈິກິສະຖານ",
        "TK": "ໂທກິໂລ",
        "TL": "ຕິມໍຕາເວັນອອກ",
        "TM": "ເຕຣີກເມນິສະຖານ",
        "TN": "ຕູນິເຊຍ",
        "TO": "ຕອງກາ",
        "TR": "ຕຸນກີ",
        "TT": "ທິນິແດດ",
        "TW": "ໄຕ້ຫວັນ",
        "TZ": "ທານຊາເນຍ",
        "UA": "ຢູເຄຼນ",
        "UG": "ອູການດາ",
        "US": "ສະຫະລັດອາເມລິກາ",
        "UY": "ລູກວຍອຸຣ",
        "UZ": "ອຸດເບກິສະຖານ",
        "VA": "ວາຕິກັນ",
        "VE": "ເວເນຊູເອລາ",
        "VG": "ບຣິທິດເວີຈິນໄອແລນ",
        "VI": "ຢູເອສເວີຈິນໄອແລນ",
        "VN": "ຫວຽດນາມ",
        "VU": "ວານົວຕູ",
        "YE": "ເຢເມນ",
        "YT": "ມາຢອດ",
        "ZA": "ອາຟະລິກາໃຕ້",
        "ZM": "ແຊມເບຍ",
        "ZW": "ຊິມບັບເວ"
    };
  }-*/;
}
