/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.autobean.shared.impl;

import com.google.gwt.autobean.client.impl.JsoSplittable;
import com.google.gwt.autobean.shared.Splittable;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.core.client.JsDate;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;

import java.util.Date;

/**
 * This a super-source version with a client-only implementation.
 */
public class StringQuoter {
  public static String quote(String raw) {
    return JsonUtils.escapeValue(raw);
  }

  public static Splittable split(String payload) {
    boolean isString = payload.charAt(0) == '\"';
    if (isString) {
      payload = "[" + payload + "]";
    }
    Splittable toReturn = JsoSplittable.create(JsonUtils.safeEval(payload));
    if (isString) {
      toReturn = toReturn.get(0);
    }
    return toReturn;
  }

  public static Date tryParseDate(String date) {
    try {
      return new Date(Long.parseLong(date));
    } catch (NumberFormatException ignored) {
    }
    try {
      JsDate js = JsDate.create(date);
      return new Date((long) js.getTime());
    } catch (JavaScriptException ignored) {
    }
    return null;
  }
}
