// 
// File:          ExceptionTest_Fib_Impl.hh
// Symbol:        ExceptionTest.Fib-v1.0
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for ExceptionTest.Fib
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 

#ifndef included_ExceptionTest_Fib_Impl_hh
#define included_ExceptionTest_Fib_Impl_hh

#ifndef included_sidl_ucxx_hh
#include "sidl_ucxx.hh"
#endif
#ifndef included_ExceptionTest_Fib_IOR_h
#include "ExceptionTest_Fib_IOR.h"
#endif
#ifndef included_ExceptionTest_Fib_hh
#include "ExceptionTest_Fib.hh"
#endif
#ifndef included_ExceptionTest_FibException_hh
#include "ExceptionTest_FibException.hh"
#endif
#ifndef included_ExceptionTest_NegativeValueException_hh
#include "ExceptionTest_NegativeValueException.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif


#line 36 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.hh"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._includes)
// Put additional includes or other arbitrary code here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._includes)
#line 40 "ExceptionTest_Fib_Impl.hh"

namespace ExceptionTest { 

  /**
   * Symbol "ExceptionTest.Fib" (version 1.0)
   * 
   * This class holds the method <code>getFib</code> that generates the
   * requested Fibonacci numbers.
   */
  class Fib_impl : public virtual ::ucxx::ExceptionTest::Fib 
#line 49 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.hh"
  // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._inherits)
#line 55 "ExceptionTest_Fib_Impl.hh"
  {

  // All data marked protected will be accessable by 
  // descendant Impl classes
  protected:

#line 58 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.hh"
    // DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._implementation)
    // Put additional implementation details here...
    // DO-NOT-DELETE splicer.end(ExceptionTest.Fib._implementation)
#line 66 "ExceptionTest_Fib_Impl.hh"

  public:
    // default constructor, shouldn't be used (required)
    Fib_impl() : StubBase(0,true) { } 

      // sidl constructor (required)
      // Note: alternate Skel constructor doesn't call addref()
      // (fixes bug #275)
      Fib_impl( struct ExceptionTest_Fib__object * s ) : StubBase(s,
        true) { _ctor(); }

      // user defined construction
      void _ctor();

      // virtual destructor (required)
      virtual ~Fib_impl() { _dtor(); }

      // user defined destruction
      void _dtor();

      // static class initializer
      static void _load();

    public:


      /**
       * <p>
       * Generate the requested Fibonacci number or generate exceptions if
       * the input Fibonacci number is invalid or if any of the maximum depth
       * or maximum value parameters are exceeded.  The last argument of the
       * method should be zero.
       * </p>
       * <p>
       * The algorithm should be similar to the <code>Java</code> code below.
       * </p>
       * <pre>
       * public int getFib(int n, int max_depth, int max_value, int depth)
       *     throws NegativeValueException, FibException {
       * 
       *   if (n < 0) {
       *     throw new NegativeValueException("n negative");
       * 
       *   } else if (depth > max_depth) {
       *     throw new TooDeepException("too deep");
       * 
       *   } else if (n == 0) {
       *     return 1;
       * 
       *   } else if (n == 1) {
       *     return 1;
       * 
       *   } else {
       *     int a = getFib(n-1, max_depth, max_value, depth+1);
       *     int b = getFib(n-2, max_depth, max_value, depth+1);
       *     if (a + b > max_value) {
       *       throw new TooBigException("too big");
       *     }
       *     return a + b;
       *   }
       * } 
       * </pre>
       */
      int32_t
      getFib_impl (
        /* in */int32_t n,
        /* in */int32_t max_depth,
        /* in */int32_t max_value,
        /* in */int32_t depth
      )
      throw ( 
        ::ucxx::ExceptionTest::NegativeValueException, 
        ::ucxx::ExceptionTest::FibException
      );

    };  // end class Fib_impl

  } // end namespace ExceptionTest

#line 140 "../../../../babel/regression/exceptions/libUCxx/ExceptionTest_Fib_Impl.hh"
// DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(ExceptionTest.Fib._misc)
#line 150 "ExceptionTest_Fib_Impl.hh"

  #endif
