// 
// File:          gov_cca_ports_ParameterPortFactory.hh
// Symbol:        gov.cca.ports.ParameterPortFactory-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.ports.ParameterPortFactory
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_ports_ParameterPortFactory_hh
#define included_gov_cca_ports_ParameterPortFactory_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 
    namespace ports { 

      class ParameterPortFactory;
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::ports::ParameterPortFactory >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_ports_ParameterPortFactory_IOR_h
#include "gov_cca_ports_ParameterPortFactory_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_Services_hh
#include "gov_cca_Services.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_gov_cca_ports_ParameterGetListener_hh
#include "gov_cca_ports_ParameterGetListener.hh"
#endif
#ifndef included_gov_cca_ports_ParameterSetListener_hh
#include "gov_cca_ports_ParameterSetListener.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 
    namespace ports { 

      /**
       * Symbol "gov.cca.ports.ParameterPortFactory" (version 0.6.3)
       * 
       * This interface supercedes the ccaffeine 
       * ConfigurableParameterPortFactory,
       * the parameters library, and all the associated cruft that
       * gunked up a component. The component writer now just needs to
       * use this port and one or more typemaps.
       * 
       * All the function names and meanings are as identical to
       * the existing ccaffeine interfaces as possible. Most just have
       * a TypeMap argument added and modernized (stl) string usage.
       * Additional functions to support the full generality of TypeMap
       * have been added.
       * 
       * Each ParameterPort is defined on a typemap the component owns.
       * A component writer can define more than one such port for a component,
       * and each will show up as a ParameterPort for UI agents.
       * The component writer can choose to be notified of 
       * parameter reads and writes using the related Listener interfaces.
       * 
       * All strings (help, prompt, value, etc) passed to this 
       * interface must be free
       * of \n and other line-breaking characters if certain
       * ancient gui clients are going to be used. This limitation is
       * in the clients rather than the ParameterPort implementation.
       * Those clients are prone to compressing redundant whitespace 
       * as well. In a rosy future, these client limitations will go away.
       */
      class ParameterPortFactory : public ::sidl::StubBase {

        //////////////////////////////////////////////////
        // 
        // User Defined Methods
        // 

      public:

        /**
         * <p>
         * Add one to the intrinsic reference count in the underlying object.
         * Object in <code>sidl</code> have an intrinsic reference count.
         * Objects continue to exist as long as the reference count is
         * positive. Clients should call this method whenever they
         * create another ongoing reference to an object or interface.
         * </p>
         * <p>
         * This does not have a return value because there is no language
         * independent type that can refer to an interface or a
         * class.
         * </p>
         */
        inline void
        addRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_addRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
          }
        }



        /**
         * Decrease by one the intrinsic reference count in the underlying
         * object, and delete the object if the reference is non-positive.
         * Objects in <code>sidl</code> have an intrinsic reference count.
         * Clients should call this method whenever they remove a
         * reference to an object or interface.
         */
        inline void
        deleteRef() throw () 
        {

          if ( !d_weak_reference ) {
            /*pack args to dispatch to ior*/
            (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
            /*dispatch to ior*/
            /*unpack results and cleanup*/
            d_self = 0;
          }
        }



        /**
         * Return true if and only if <code>obj</code> refers to the same
         * object as this object.
         */
        bool
        isSame (
          /* in */ ::sidl::BaseInterface iobj
        )
        throw () 
        ;



        /**
         * Check whether the object can support the specified interface or
         * class.  If the <code>sidl</code> type name in <code>name</code>
         * is supported, then a reference to that object is returned with the
         * reference count incremented.  The callee will be responsible for
         * calling <code>deleteRef</code> on the returned object.  If
         * the specified type is not supported, then a null reference is
         * returned.
         */
        ::sidl::BaseInterface
        queryInt (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return whether this object is an instance of the specified type.
         * The string name must be the <code>sidl</code> type name.  This
         * routine will return <code>true</code> if and only if a cast to
         * the string type name would succeed.
         */
        bool
        isType (
          /* in */ const ::std::string& name
        )
        throw () 
        ;



        /**
         * Return the meta-data about the class implementing this interface.
         */
        ::sidl::ClassInfo
        getClassInfo() throw () 
        ;


        /**
         * Initialize the portData for use in a ParameterPort
         *  with name portName.
         *  More than one such port can be defined.
         *  The given string portName will be cached in the TypeMap
         *  as the result of this function and must not be changed
         *  by the component henceforth.
         *  
         *  @param portData the user-supplied TypeMap associated with the port;
         *       It is somehow shared between the ParameterPortFactory
         *       and the component. The ParameterPortFactory will
         *       not read or change preexisting values in portData except those
         *       requested via the addRequest functions and those
         *       keys starting with the reserved prefix "gcpPPF.".
         *  @param portName The name of the ParameterPort to appear in
         *       the component. It must not conflict with other port
         *       names in the same component. The port name "CONFIG"
         *       is recommended if only one ParameterPort is being defined.
         *  
         * 
         */
        void
        initParameterData (
          /* inout */ ::gov::cca::TypeMap& portData,
          /* in */ const ::std::string& portName
        )
        throw () 
        ;



        /**
         * Define the window title for the parameter UI dialog.
         */
        void
        setBatchTitle (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& title
        )
        throw () 
        ;



        /**
         * Define the next tab/group title to use. All
         * addRequest subsequent calls will add to this group.
         * Multiple dialog tabs/groups can be defined in this way.
         */
        void
        setGroupName (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& newGroupName
        )
        throw () 
        ;


        /**
         * User-defined non-static method.
         */
        void
        setGroupName (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& newGroupName,
          /* in */ const ::std::string& groupTitle
        )
        throw () 
        ;



        /**
         * Define a boolean parameter and its default state.
         * The configured value is always available by
         * portData->getBool(name, ...);
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestBoolean (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ bool bdefault
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a int parameter and its default state.
         * The configured value is always available by
         * portData->getInt(name, ...) and it will be
         * in the range [low, high]. The initially given bounds
         * can be replaced with a choice list later.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestInt (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ int32_t idefault,
          /* in */ int32_t low,
          /* in */ int32_t high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a long parameter and its default state.
         * The configured value is always available by
         * portData->getLong(name, ...) and it will be
         * in the range [low, high]. The initially given bounds
         * can be replaced with a choice list later.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestLong (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ int64_t ldefault,
          /* in */ int64_t low,
          /* in */ int64_t high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a float parameter and its default state.
         * The configured value is always available by
         * portData->getFloat(name, ...) and it will be
         * in the range [low, high]. The initially given bounds
         * can be replaced with a choice list later.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestFloat (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ float fdefault,
          /* in */ float low,
          /* in */ float high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a double parameter and its default state.
         * The configured value is always available by
         * portData->getDouble(name, ...) and it will be
         * in the range [low, high]. The initially given bounds
         * can be replaced with a choice list later.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestDouble (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ double ddefault,
          /* in */ double low,
          /* in */ double high
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a string parameter and its default state.
         * The configured value is always available by
         * portData->getString(name, ...).
         * If no addRequestStringChoice calls are made, the
         * user input may be any string. If addRequestStringChoice
         * is used, the value will be one among the choices.
         * If addRequestStringChoice is used, deflt must
         * be among the choices defined.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestString (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ const ::std::string& help,
          /* in */ const ::std::string& prompt,
          /* in */ const ::std::string& sdefault
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Define a new choice for a string parameter.
         *  If no calls to this function are made for a given
         *  name, then any form of string will be acceptable input.
         * @throws gov.cca.CCAException if key is unknown or mistyped.
         */
        void
        addRequestStringChoice (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& key,
          /* in */ const ::std::string& choice
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * As addRequestStringChoice, but in bulk. 
         */
        void
        addStringChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& key,
          /* in */ ::sidl::array< ::std::string> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addIntChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array<int32_t> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addLongChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array<int64_t> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addFloatChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array<float> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addDoubleChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array<double> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addFcomplexChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array< ::sidl::fcomplex> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Replace the bounds on the named parameter by a list. 
         */
        void
        addDcomplexChoices (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ const ::std::string& name,
          /* in */ ::sidl::array< ::sidl::dcomplex> choices
        )
        throw ( 
          ::gov::cca::CCAException
        );



        /**
         * Clear all previously added requests, titles, groups. After
         *  this call, it is as if the ParameterPort has
         *  seen initParameterData but otherwise never configured.
         *  The values of
         *  previously defined parameters (but not bounds, etc)
         *  remain in the TypeMap.
         *  Typically, this is used only by someone implementing
         *  the updateParameterPort function from
         *  interface ParameterGetListener.
         */
        void
        clearRequests (
          /* in */ ::gov::cca::TypeMap portData
        )
        throw () 
        ;



        /**
         * Register listener (the component) that wishes to have
         * a chance to change the contents of its ParameterPort
         * just before the parameters TypeMap is read.
         * @param powner a pointer to the listener that will be
         * forgotten when it is no longer needed. 
         */
        void
        registerUpdater (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ ::gov::cca::ports::ParameterGetListener powner
        )
        throw () 
        ;



        /**
         * Register listener (the component) if it wishes to be
         * informed when an parameter is changed via writeConfigurationMap.
         * Listeners are called after values are set.
         */
        void
        registerUpdatedListener (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ ::gov::cca::ports::ParameterSetListener powner
        )
        throw () 
        ;



        /**
         * Signal that the ParameterPort is fully defined and should
         * now pop out on the component.
         * The component is free to hold the portData map internally
         * without adding it until some desired time.
         * The Services passed here
         * must be the component's own Services handle.
         * The ParameterPortFactory takes care of addProvidesPort.
         */
        void
        addParameterPort (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ ::gov::cca::Services svc
        )
        throw () 
        ;



        /**
         * Cause a previously defined parameter port to go away.
         * This function should be called at component shutdown
         * (setService(0)) time for any parameter ports that have
         * been added but not yet removed.
         * The ParameterPortFactory takes care of removeProvidesPort.
         * This does not change the parameter values in the
         * TypeMap.
         */
        void
        removeParameterPort (
          /* in */ ::gov::cca::TypeMap portData,
          /* in */ ::gov::cca::Services svc
        )
        throw () 
        ;



        //////////////////////////////////////////////////
        // 
        // End User Defined Methods
        // (everything else in this file is specific to
        //  Babel's C++ bindings)
        // 

      public:
        typedef struct gov_cca_ports_ParameterPortFactory__object ior_t;
        typedef struct gov_cca_ports_ParameterPortFactory__external ext_t;
        typedef struct gov_cca_ports_ParameterPortFactory__sepv sepv_t;

        // default constructor
        ParameterPortFactory() : d_self(0), d_weak_reference(false) { }

        // default destructor
        virtual ~ParameterPortFactory ();

        // copy constructor
        ParameterPortFactory ( const ParameterPortFactory& original );

        // assignment operator
        ParameterPortFactory& operator= ( const ParameterPortFactory& rhs );

        // conversion from ior to C++ class
        ParameterPortFactory ( ParameterPortFactory::ior_t* ior );

        // Alternate constructor: does not call addRef()
        // (sets d_weak_reference=isWeak)
        // For internal use by Impls (fixes bug#275)
        ParameterPortFactory ( ParameterPortFactory::ior_t* ior, bool isWeak );

        // conversion from a StubBase
        ParameterPortFactory ( const ::sidl::StubBase& base );

        ior_t* _get_ior() { return d_self; }

        const ior_t* _get_ior() const { return d_self; }

        void _set_ior( ior_t* ptr ) { d_self = ptr; }

        bool _is_nil() const { return (d_self==0); }

        bool _not_nil() const { return (d_self!=0); }

        bool operator !() const { return (d_self==0); }

      protected:
        virtual void* _cast(const char* type) const;

      private:
        // Pointer to sidl's IOR type (one per instance)
        ior_t * d_self;

        // Weak references (used by Impl's only) don't add/deleteRef()
        bool d_weak_reference;

        // Pointer to external (DLL loadable) symbols (shared among instances)
        static const ext_t * s_ext;

      public:
        static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

      }; // end class ParameterPortFactory
    } // end namespace ports
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::ports::ParameterPortFactory > {
    typedef array< ::gov::cca::ports::ParameterPortFactory > cxx_array_t;
    typedef ::gov::cca::ports::ParameterPortFactory cxx_item_t;
    typedef struct gov_cca_ports_ParameterPortFactory__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_ports_ParameterPortFactory__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::ports::ParameterPortFactory 
      > > iterator;
    typedef  const_array_iter< array_traits< 
      ::gov::cca::ports::ParameterPortFactory > > const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::ports::ParameterPortFactory >: public 
    interface_array< array_traits< ::gov::cca::ports::ParameterPortFactory > > {
  public:
    typedef interface_array< array_traits< 
      ::gov::cca::ports::ParameterPortFactory > > Base;
    typedef array_traits< ::gov::cca::ports::ParameterPortFactory 
      >::cxx_array_t          cxx_array_t;
    typedef array_traits< ::gov::cca::ports::ParameterPortFactory >::cxx_item_t 
      cxx_item_t;
    typedef array_traits< ::gov::cca::ports::ParameterPortFactory 
      >::ior_array_t          ior_array_t;
    typedef array_traits< ::gov::cca::ports::ParameterPortFactory 
      >::ior_array_internal_t ior_array_internal_t;
    typedef array_traits< ::gov::cca::ports::ParameterPortFactory >::ior_item_t 
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_ports_ParameterPortFactory__array* src = 0) : 
      Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::ports::ParameterPortFactory >&src) : 
      Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::ports::ParameterPortFactory >&
    operator =( const array< ::gov::cca::ports::ParameterPortFactory >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
