/*
 * File:          sidl_BaseException_jniStub.c
 * Symbol:        sidl.BaseException-v0.9.1
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.BaseException
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_BaseException_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_BaseException__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_BaseException__object*) ptr;
}

/*
 * <p>
 * Add one to the intrinsic reference count in the underlying object.
 * Object in <code>sidl</code> have an intrinsic reference count.
 * Objects continue to exist as long as the reference count is
 * positive. Clients should call this method whenever they
 * create another ongoing reference to an object or interface.
 * </p>
 * <p>
 * This does not have a return value because there is no language
 * independent type that can refer to an interface or a
 * class.
 * </p>
 */

static void
jni_addRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Decrease by one the intrinsic reference count in the underlying
 * object, and delete the object if the reference is non-positive.
 * Objects in <code>sidl</code> have an intrinsic reference count.
 * Clients should call this method whenever they remove a
 * reference to an object or interface.
 */

static void
jni_deleteRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_deleteRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */

static jboolean
jni_isSame(
  JNIEnv* env,
  jobject obj,
  jobject _arg_iobj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  struct sidl_BaseInterface__object* _tmp_iobj = (struct 
    sidl_BaseInterface__object*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_iobj = (struct sidl_BaseInterface__object*) sidl_Java_J2I_ifc(env,
    _arg_iobj, "sidl.BaseInterface");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isSame))(
    _ior->d_object,
    _tmp_iobj);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */

static jobject
jni_queryInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct sidl_BaseInterface__object* _ior_res = (struct 
    sidl_BaseInterface__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_queryInt))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseInterface");

  return _res;
}

/*
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */

static jboolean
jni_isType(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isType))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Return the meta-data about the class implementing this interface.
 */

static jobject
jni_getClassInfo(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  struct sidl_ClassInfo__object* _ior_res = (struct sidl_ClassInfo__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getClassInfo))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.ClassInfo");

  return _res;
}

/*
 * Return the message associated with the exception.
 */

static jstring
jni_getNote(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getNote))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Set the message associated with the exception.
 */

static void
jni_setNote(
  JNIEnv* env,
  jobject obj,
  jstring _arg_message)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _tmp_message = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_message = sidl_Java_J2I_string(env, _arg_message);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setNote))(
    _ior->d_object,
    _tmp_message);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_message);
}

/*
 * Returns formatted string containing the concatenation of all 
 * tracelines.
 */

static jstring
jni_getTrace(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getTrace))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Adds a stringified entry/line to the stack trace.
 */

static void
jni_addLine(
  JNIEnv* env,
  jobject obj,
  jstring _arg_traceline)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _tmp_traceline = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_traceline = sidl_Java_J2I_string(env, _arg_traceline);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addLine))(
    _ior->d_object,
    _tmp_traceline);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_traceline);
}

/*
 * Formats and adds an entry to the stack trace based on the 
 * file name, line number, and method name.
 */

static void
jni_add(
  JNIEnv* env,
  jobject obj,
  jstring _arg_filename,
  jint _arg_lineno,
  jstring _arg_methodname)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_BaseException__object* _ior = NULL;
  char* _tmp_filename = (char*) NULL;
  int32_t _tmp_lineno = 0;
  char* _tmp_methodname = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_filename = sidl_Java_J2I_string(env, _arg_filename);
  _tmp_lineno = (int32_t) _arg_lineno;
  _tmp_methodname = sidl_Java_J2I_string(env, _arg_methodname);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_add))(
    _ior->d_object,
    _tmp_filename,
    _tmp_lineno,
    _tmp_methodname);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_filename);
  sidl_String_free(_tmp_methodname);
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_BaseException__register(JNIEnv* env)
{
  JNINativeMethod methods[11];
  jclass cls;

  methods[0].name      = "addRef";
  methods[0].signature = "()V";
  methods[0].fnPtr     = (void *)jni_addRef;
  methods[1].name      = "deleteRef";
  methods[1].signature = "()V";
  methods[1].fnPtr     = (void *)jni_deleteRef;
  methods[2].name      = "isSame";
  methods[2].signature = "(Lsidl/BaseInterface;)Z";
  methods[2].fnPtr     = (void *)jni_isSame;
  methods[3].name      = "queryInt";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseInterface;";
  methods[3].fnPtr     = (void *)jni_queryInt;
  methods[4].name      = "isType";
  methods[4].signature = "(Ljava/lang/String;)Z";
  methods[4].fnPtr     = (void *)jni_isType;
  methods[5].name      = "getClassInfo";
  methods[5].signature = "()Lsidl/ClassInfo;";
  methods[5].fnPtr     = (void *)jni_getClassInfo;
  methods[6].name      = "getNote";
  methods[6].signature = "()Ljava/lang/String;";
  methods[6].fnPtr     = (void *)jni_getNote;
  methods[7].name      = "setNote";
  methods[7].signature = "(Ljava/lang/String;)V";
  methods[7].fnPtr     = (void *)jni_setNote;
  methods[8].name      = "getTrace";
  methods[8].signature = "()Ljava/lang/String;";
  methods[8].fnPtr     = (void *)jni_getTrace;
  methods[9].name      = "add";
  methods[9].signature = "(Ljava/lang/String;)V";
  methods[9].fnPtr     = (void *)jni_addLine;
  methods[10].name      = "add";
  methods[10].signature = "(Ljava/lang/String;ILjava/lang/String;)V";
  methods[10].fnPtr     = (void *)jni_add;


  cls = (*env)->FindClass(env, "sidl/BaseException$Wrapper");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 11);
    (*env)->DeleteLocalRef(env, cls);
  }
}
