/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.config;

import gov.llnl.babel.xml.ElementIterator;
import gov.llnl.babel.xml.XMLUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Metadata {
    private HashMap d_parameters = new HashMap();
    private HashMap d_summaries = new HashMap();
    private HashMap d_descriptions = new HashMap();

    public Metadata(String uri) throws IOException, SAXException {
        this.parseXML(uri);
    }

    public Set getValidLanguages() {
        return this.d_parameters.keySet();
    }

    public Set getValidOptions(String language) {
        HashMap options = (HashMap)this.d_parameters.get(language);
        return options == null ? null : options.keySet();
    }

    public Set getValidOptionParameters(String language, String option) {
        HashMap options = (HashMap)this.d_parameters.get(language);
        return options == null ? null : options.get(option);
    }

    public String getOptionSummary(String language, String option) {
        HashMap options = (HashMap)this.d_summaries.get(language);
        return options == null ? null : options.get(option);
    }

    public String getOptionDescription(String language, String option) {
        HashMap options = (HashMap)this.d_descriptions.get(language);
        return options == null ? null : options.get(option);
    }

    private void parseXML(String uri) throws IOException, SAXException {
        Document document = XMLUtilities.parse(uri);
        if (document == null) {
            throw new SAXException("Error parsing XML metadata description (empty document)");
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            throw new SAXException("No root element in XML metadata document");
        }
        if (!"ConfigurationMetadata".equals(root.getTagName())) {
            throw new SAXException("Incorrect root element in XML metadata document");
        }
        ElementIterator languages = new ElementIterator(root, "Language");
        while (languages.hasNext()) {
            Element language = (Element)languages.next();
            String language_name = language.getAttribute("name");
            ElementIterator options = new ElementIterator(language, "Option");
            if (!options.hasNext()) {
                this.d_parameters.put(language_name, null);
                this.d_summaries.put(language_name, null);
                this.d_descriptions.put(language_name, null);
                continue;
            }
            HashMap param_map = new HashMap();
            HashMap<String, String> summary_map = new HashMap<String, String>();
            HashMap<String, String> description_map = new HashMap<String, String>();
            while (options.hasNext()) {
                Element option = (Element)options.next();
                String option_name = option.getAttribute("name");
                Element c = XMLUtilities.lookupElement(option, "Comment");
                if (c != null) {
                    String summary = c.getAttribute("summary");
                    String descr = XMLUtilities.formatChildren(c);
                    summary_map.put(option_name, summary);
                    description_map.put(option_name, descr);
                }
                HashSet<String> param_set = new HashSet<String>();
                ElementIterator parameters = new ElementIterator(option, "Parameter");
                while (parameters.hasNext()) {
                    Element parameter = (Element)parameters.next();
                    String choice = parameter.getAttribute("choice");
                    param_set.add(choice);
                }
                param_map.put(option_name, param_set);
            }
            this.d_parameters.put(language_name, param_map);
            this.d_summaries.put(language_name, summary_map);
            this.d_descriptions.put(language_name, description_map);
        }
    }
}

