/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeConstants;
import gov.llnl.babel.backend.Configuration;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.writers.PrettyWriter;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class LanguageWriter
extends PrettyWriter
implements CodeConstants {
    private static final String FORMAT = "yyyyMMdd HH:mm:ss zz";

    public LanguageWriter(PrintWriter writer) {
        super(writer);
    }

    public abstract void beginBlockComment(boolean var1);

    public abstract void endBlockComment(boolean var1);

    public abstract void writeCommentLine(String var1);

    public void writeComment(String s, boolean is_doc) {
        if (s != null && s.length() > 0) {
            this.beginBlockComment(is_doc);
            this.println(s);
            this.endBlockComment(is_doc);
        }
    }

    public String safeCommentString(String string) {
        return string;
    }

    public void writeComment(Comment comment, boolean is_doc) {
        boolean found_comment = false;
        String[] lines = null;
        if (comment != null && (lines = comment.getComment()) != null && lines.length > 0) {
            found_comment = true;
        }
        if (found_comment) {
            this.beginBlockComment(is_doc);
            if (found_comment) {
                for (int l = 0; l < lines.length; ++l) {
                    this.println(this.safeCommentString(lines[l]));
                }
            }
            this.endBlockComment(is_doc);
        }
    }

    public void writeComment(Symbol symbol, boolean is_doc, boolean output_sym) {
        boolean found_comment = false;
        Comment comment = symbol.getComment();
        String[] lines = null;
        if (comment != null && (lines = comment.getComment()) != null && lines.length > 0) {
            found_comment = true;
        }
        if (found_comment || output_sym) {
            this.beginBlockComment(is_doc);
            if (output_sym) {
                this.print("Symbol \"");
                this.print(symbol.getFullName());
                this.print("\" (version ");
                this.print(symbol.getSymbolID().getVersion().getVersionString());
                this.println(")");
            }
            if (found_comment) {
                if (output_sym) {
                    this.println();
                }
                for (int l = 0; l < lines.length; ++l) {
                    this.println(this.safeCommentString(lines[l]));
                }
            }
            this.endBlockComment(is_doc);
        }
    }

    public void writeComment(Symbol symbol, boolean is_doc) {
        this.writeComment(symbol, is_doc, true);
    }

    public void writeComment(Method method, boolean is_doc, boolean add_default) {
        boolean found_comment = false;
        Comment comment = method.getComment();
        String[] lines = null;
        if (comment != null && (lines = comment.getComment()) != null && lines.length > 0) {
            found_comment = true;
        }
        if (found_comment || add_default) {
            this.beginBlockComment(is_doc);
            if (found_comment) {
                for (int l = 0; l < lines.length; ++l) {
                    this.println(this.safeCommentString(lines[l]));
                }
            } else {
                this.println("Method:  " + method.getShortMethodName() + "[" + method.getNameExtension() + "]");
            }
            this.endBlockComment(is_doc);
        }
    }

    public void writeComment(Method method, boolean is_doc) {
        this.writeComment(method, is_doc, true);
    }

    public void writeComment(Comment comment, String alt) {
        boolean printalt = false;
        if (comment != null) {
            String[] lines = comment.getComment();
            if (lines != null && lines[0] != null && lines[0].length() > 0) {
                this.println();
                this.beginBlockComment(true);
                for (int l = 0; l < lines.length; ++l) {
                    this.println(this.safeCommentString(lines[l]));
                }
                this.endBlockComment(true);
            } else {
                printalt = true;
            }
        } else {
            printalt = true;
        }
        if (printalt && alt != null && alt.length() != 0) {
            this.beginBlockComment(true);
            this.println(alt);
            this.endBlockComment(true);
        }
    }

    public void writeBanner(Symbol symbol, String file, boolean is_Impl, String desc) {
        this.beginBlockComment(false);
        this.println("File:          " + file);
        this.print("Symbol:        ");
        this.println(symbol.getSymbolID().getSymbolName());
        this.print("Symbol Type:   ");
        switch (symbol.getSymbolType()) {
            case 12: {
                this.println("class");
                break;
            }
            case 11: {
                this.println("enumeration");
                break;
            }
            case 13: {
                this.println("interface");
                break;
            }
            case 14: {
                this.println("package");
            }
        }
        this.print("Babel Version: ");
        this.println("0.10.2");
        if (!BabelConfiguration.getInstance().suppressTimestamps()) {
            this.print("sidl Created:  ");
            this.println(symbol.getMetadata().getDateAsString());
            String format = FORMAT;
            this.print("Generated:     ");
            this.println(new SimpleDateFormat(format).format(new Date()));
        }
        String name = symbol.getFullName();
        if (Configuration.getInstance().isBuiltinSymbol(name)) {
            this.println("Release:       $Name:  $");
            this.println("Revision:      @(#) $Id: $");
        }
        this.print("Description:   ");
        this.println(desc);
        this.println();
        if (Configuration.getInstance().isBuiltinSymbol(name)) {
            this.print("Copyright (c) 2000-2002, ");
            this.println("The Regents of the University of California.");
            this.println("Produced at the Lawrence Livermore National Laboratory.");
            this.println("Written by the Components Team <components@llnl.gov>");
            this.println("All rights reserved.");
            this.println();
            this.println("This file is part of Babel. For more information, see");
            this.println("http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file");
            this.println("for Our Notice and the LICENSE file for the GNU Lesser General Public");
            this.println("License.");
            this.println();
            this.println("This program is free software; you can redistribute it and/or modify it");
            this.println("under the terms of the GNU Lesser General Public License (as published by");
            this.println("the Free Software Foundation) version 2.1 dated February 1999.");
            this.println();
            this.println("This program is distributed in the hope that it will be useful, but");
            this.println("WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF");
            this.println("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and");
            this.println("conditions of the GNU Lesser General Public License for more details.");
            this.println();
            this.println("You should have recieved a copy of the GNU Lesser General Public License");
            this.println("along with this program; if not, write to the Free Software Foundation,");
            this.println("Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA");
            this.println();
        }
        this.print("WARNING: ");
        if (is_Impl) {
            this.println("Automatically generated; only changes within splicers preserved");
        } else {
            this.println("Automatically generated; changes will be lost");
        }
        Set entries = symbol.getMetadata().getMetadataDatabase().entrySet();
        if (entries != null && entries.size() > 0) {
            ArrayList sorted = Utilities.sort(entries);
            int width = Utilities.getWidth(entries);
            this.println();
            Iterator e = sorted.iterator();
            while (e.hasNext()) {
                Map.Entry entry = (Map.Entry)e.next();
                String key = (String)entry.getKey();
                if (key == null || BabelConfiguration.getInstance().suppressTimestamps() && (key.equals("source-url") || key.equals("source-line"))) continue;
                this.printAligned(key, width);
                this.print(" = ");
                this.println((String)entry.getValue());
            }
        }
        this.endBlockComment(false);
    }
}

