/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.gudy.azureus2.core3.logging.LGLogger;

public class UpdateJarPatcher {
    protected Map patch_entries = new HashMap();

    protected UpdateJarPatcher(InputStream input_file, InputStream patch_file, OutputStream output_file) throws IOException {
        JarEntry os_entry;
        InputStream eis;
        String name;
        JarEntry is_entry;
        this.readPatchEntries(patch_file);
        JarInputStream jis = new JarInputStream(input_file);
        JarOutputStream jos = new JarOutputStream(output_file);
        while ((is_entry = jis.getNextJarEntry()) != null) {
            if (is_entry.isDirectory()) continue;
            name = is_entry.getName();
            eis = this.getPatch(name);
            if (eis != null) {
                LGLogger.log(0, "patch - replace: " + name);
            } else {
                eis = jis;
            }
            os_entry = new JarEntry(name);
            UpdateJarPatcher.writeEntry(jos, os_entry, eis);
        }
        Iterator it = this.patch_entries.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            LGLogger.log(0, "patch - add: " + name);
            eis = (InputStream)this.patch_entries.get(name);
            os_entry = new JarEntry(name);
            UpdateJarPatcher.writeEntry(jos, os_entry, eis);
        }
        JarEntry entry2 = new JarEntry("META-INF/MANIFEST.MF");
        ByteArrayInputStream bais = new ByteArrayInputStream("Manifest-Version: 1.0\r\n\r\n".getBytes());
        UpdateJarPatcher.writeEntry(jos, entry2, bais);
        jos.finish();
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry2, InputStream data) throws IOException {
        jos.putNextEntry(entry2);
        byte[] newBytes = new byte[4096];
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
    }

    protected void readPatchEntries(InputStream is) throws IOException {
        JarEntry ent;
        JarInputStream jis = new JarInputStream(is);
        while ((ent = jis.getNextJarEntry()) != null) {
            int l;
            if (ent.isDirectory()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((l = jis.read(buffer)) > 0) {
                baos.write(buffer, 0, l);
            }
            String name = ent.getName();
            this.patch_entries.put(ent.getName(), new ByteArrayInputStream(baos.toByteArray()));
        }
    }

    public InputStream getPatch(String name) {
        return (InputStream)this.patch_entries.remove(name);
    }
}

