/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.peers.PeerTableItem;
import org.gudy.azureus2.plugins.ui.tables.peers.PluginPeerItem;
import org.gudy.azureus2.plugins.ui.tables.peers.PluginPeerItemFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableColumnImpl;

public class OldPeerPluginItem
extends TableColumnImpl
implements TableCellAddedListener {
    private PluginPeerItemFactory oldFactory;
    private String oldFactoryType;

    public OldPeerPluginItem(String sTableID, String sCellName, PluginPeerItemFactory item) {
        super(sTableID, sCellName);
        this.oldFactory = item;
        this.oldFactoryType = this.oldFactory.getType();
        this.addCellAddedListener(this);
        this.setRefreshInterval(-2);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    PeerTableItem {
        PluginPeerItem pluginItem;
        TableCell cell;
        boolean bTextSet;

        public Cell(TableCell item) {
            this.cell = item;
            this.pluginItem = OldPeerPluginItem.this.oldFactory.getInstance(this);
            this.cell.addRefreshListener(this);
        }

        public Peer getPeer() {
            return (Peer)this.cell.getDataSource();
        }

        public void refresh(TableCell cell) {
            try {
                if (cell.isShown()) {
                    this.bTextSet = false;
                    this.pluginItem.refresh();
                    if (OldPeerPluginItem.this.oldFactoryType.equals("S")) {
                        String s = this.pluginItem.getStringValue();
                        cell.setSortValue((Comparable)((Object)s));
                        if (!this.bTextSet && !cell.isValid()) {
                            cell.setText(s);
                        }
                    } else {
                        int i = this.pluginItem.getIntValue();
                        if (!this.bTextSet && !cell.isValid()) {
                            cell.setText(String.valueOf(i));
                        }
                        cell.setSortValue(i);
                    }
                }
            }
            catch (Throwable e) {
                LGLogger.log(3, "Plugin in PeersView generated an exception : " + e);
                Debug.printStackTrace(e);
            }
        }

        public boolean setText(String s) {
            this.bTextSet = true;
            return this.cell.setText(s);
        }
    }
}

