/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.utils.TableStructureEventDispatcher;

public class TableColumnImpl
implements TableColumnCore {
    private String sName;
    private String sTitleLanguageKey = null;
    private int iAlignment;
    private int iType;
    private int iPosition;
    private int iWidth;
    private int iInterval;
    private String sTableID;
    private boolean bColumnAdded;
    private boolean bCoreDataSource;
    private ArrayList cellRefreshListeners;
    private ArrayList cellAddedListeners;
    private ArrayList cellDisposeListeners;
    private ArrayList cellToolTipListeners;
    private int iConsecutiveErrCount;
    private ArrayList menuItems;
    private AEMonitor this_mon = new AEMonitor("TableColumn");

    public TableColumnImpl(String tableID, String columnID) {
        this.sTableID = tableID;
        this.sName = columnID;
        this.iType = 1;
        this.iPosition = -1;
        this.iWidth = 50;
        this.iAlignment = 1;
        this.bColumnAdded = false;
        this.bCoreDataSource = false;
        this.iInterval = -3;
        this.iConsecutiveErrCount = 0;
    }

    public void initialize(int iAlignment, int iPosition, int iWidth, int iInterval) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.iPosition = iPosition;
        this.iWidth = iWidth;
        this.iInterval = iInterval;
    }

    public void initialize(int iAlignment, int iPosition, int iWidth) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = iAlignment;
        this.iPosition = iPosition;
        this.iWidth = iWidth;
    }

    public String getName() {
        return this.sName;
    }

    public String getTableID() {
        return this.sTableID;
    }

    public void setType(int type) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iType = type;
    }

    public int getType() {
        return this.iType;
    }

    public void setWidth(int width) {
        if (width == this.iWidth || width < 0) {
            return;
        }
        this.iWidth = width;
        if (this.bColumnAdded && this.iPosition != -1) {
            TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
            tsed.columnSizeChanged(this);
            if (this.iType == 2) {
                this.invalidateCells();
            }
        }
    }

    public int getWidth() {
        return this.iWidth;
    }

    public void setPosition(int position) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iPosition = position;
    }

    public int getPosition() {
        return this.iPosition;
    }

    public void setAlignment(int alignment) {
        if (this.bColumnAdded) {
            throw new UIRuntimeException("Can't set properties. Column '" + this.sName + " already added");
        }
        this.iAlignment = alignment;
    }

    public int getAlignment() {
        return this.iAlignment;
    }

    public void addCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                this.cellRefreshListeners = new ArrayList();
            }
            this.cellRefreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeCellRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellRefreshListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.cellRefreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setRefreshInterval(int interval) {
        this.iInterval = interval;
    }

    public int getRefreshInterval() {
        return this.iInterval;
    }

    public void addCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                this.cellAddedListeners = new ArrayList();
            }
            this.cellAddedListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeCellAddedListener(TableCellAddedListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellAddedListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.cellAddedListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                this.cellDisposeListeners = new ArrayList();
            }
            this.cellDisposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeCellDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellDisposeListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.cellDisposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                this.cellToolTipListeners = new ArrayList();
            }
            this.cellToolTipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeCellToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellToolTipListeners == null) {
                this.this_mon.exit();
                return;
            }
            this.cellToolTipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void invalidateCells() {
        TableStructureEventDispatcher tsed = TableStructureEventDispatcher.getInstance(this.sTableID);
        tsed.columnInvalidate(this);
    }

    public void setColumnAdded(boolean bAdded) {
        this.bColumnAdded = bAdded;
    }

    public boolean getColumnAdded() {
        return this.bColumnAdded;
    }

    public void setUseCoreDataSource(boolean bCoreDataSource) {
        this.bCoreDataSource = bCoreDataSource;
    }

    public boolean getUseCoreDataSource() {
        return this.bCoreDataSource;
    }

    public void invokeCellRefreshListeners(TableCellCore cell) {
        if (this.cellRefreshListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellRefreshListeners.size()) {
            ((TableCellRefreshListener)this.cellRefreshListeners.get(i)).refresh(cell);
            ++i;
        }
    }

    public void invokeCellAddedListeners(TableCellCore cell) {
        if (this.cellAddedListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellAddedListeners.size()) {
            ((TableCellAddedListener)this.cellAddedListeners.get(i)).cellAdded(cell);
            ++i;
        }
    }

    public void invokeCellDisposeListeners(TableCellCore cell) {
        if (this.cellDisposeListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.cellDisposeListeners.size()) {
            ((TableCellDisposeListener)this.cellDisposeListeners.get(i)).dispose(cell);
            ++i;
        }
    }

    public void invokeCellToolTipListeners(TableCellCore cell, int type) {
        if (this.cellToolTipListeners == null) {
            return;
        }
        if (type == 0) {
            int i = 0;
            while (i < this.cellToolTipListeners.size()) {
                ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHover(cell);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.cellToolTipListeners.size()) {
                ((TableCellToolTipListener)this.cellToolTipListeners.get(i)).cellHoverComplete(cell);
                ++i;
            }
        }
    }

    public void setPositionNoShift(int position) {
        this.iPosition = position;
    }

    public void loadSettings() {
        String sItemPrefix = "Table." + this.sTableID + "." + this.sName;
        this.iWidth = COConfigurationManager.getIntParameter(String.valueOf(sItemPrefix) + ".width", this.iWidth);
        if (this.iWidth <= 0) {
            this.iWidth = 100;
        }
        this.iPosition = COConfigurationManager.getIntParameter(String.valueOf(sItemPrefix) + ".position", this.iPosition);
    }

    public void saveSettings() {
        String sItemPrefix = "Table." + this.sTableID + "." + this.sName;
        COConfigurationManager.setParameter(String.valueOf(sItemPrefix) + ".position", this.iPosition);
        COConfigurationManager.setParameter(String.valueOf(sItemPrefix) + ".width", this.iWidth);
    }

    public int getSWTAlign() {
        return this.iAlignment == 1 ? 16384 : (this.iAlignment == 3 ? 0x1000000 : 131072);
    }

    public String getTitleLanguageKey() {
        try {
            this.this_mon.enter();
            if (this.sTitleLanguageKey == null) {
                String sKeyPrefix;
                this.sTitleLanguageKey = String.valueOf(this.sTableID) + ".column." + this.sName;
                if (!MessageText.keyExists(this.sTitleLanguageKey) && MessageText.keyExists(String.valueOf(sKeyPrefix = String.valueOf(this.sTableID.equals("MySeeders") ? "MyTorrents" : this.sTableID) + "View.") + this.sName)) {
                    this.sTitleLanguageKey = String.valueOf(sKeyPrefix) + this.sName;
                }
            }
            String string = this.sTitleLanguageKey;
            this.this_mon.exit();
            return string;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public int getConsecutiveErrCount() {
        return this.iConsecutiveErrCount;
    }

    public void setConsecutiveErrCount(int iCount) {
        this.iConsecutiveErrCount = iCount;
    }

    public void removeContextMenuItem(TableContextMenuItem menuItem) {
        if (this.menuItems == null) {
            return;
        }
        this.menuItems.remove(menuItem);
    }

    public TableContextMenuItem addContextMenuItem(String key) {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl("", key);
        this.menuItems.add(item);
        return item;
    }

    public TableContextMenuItem[] getContextMenuItems() {
        if (this.menuItems == null) {
            return new TableContextMenuItem[0];
        }
        return this.menuItems.toArray(new TableContextMenuItem[0]);
    }
}

