/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.ColorParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class ConfigSectionInterfaceDisplay
implements ConfigSectionSWT {
    private static final String[] sColorsToOverride = new String[]{"progressBar", "error", "warning", "altRow"};
    private Color[] colorsToOverride = new Color[]{Colors.colorProgressBar, Colors.colorError, Colors.colorWarning, Colors.colorAltRow};
    private Button[] btnColorReset = new Button[sColorsToOverride.length];

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "display";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cLook = new Composite(parent, 0);
        cLook.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cLook.setLayout((Layout)layout);
        BooleanParameter bpCustomTab = new BooleanParameter(cLook, "useCustomTab", true, "ConfigView.section.style.useCustomTabs");
        Control cFancyTab = new BooleanParameter(cLook, "GUI_SWT_bFancyTab", true, "ConfigView.section.style.useFancyTabs").getControl();
        Control[] controls = new Control[]{cFancyTab};
        bpCustomTab.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(controls));
        new BooleanParameter(cLook, "Show Download Basket", false, "ConfigView.section.style.showdownloadbasket");
        new BooleanParameter(cLook, "Add URL Silently", false, "ConfigView.section.style.addurlsilently");
        new BooleanParameter(cLook, "add_torrents_silently", false, "ConfigView.section.interface.display.add_torrents_silently");
        if (Constants.isWindowsXP) {
            final Button enableXPStyle = new Button(cLook, 32);
            Messages.setLanguageText((Widget)enableXPStyle, "ConfigView.section.style.enableXPStyle");
            boolean enabled = false;
            boolean valid = false;
            try {
                File f = new File(String.valueOf(System.getProperty("java.home")) + "\\bin\\javaw.exe.manifest");
                if (f.exists()) {
                    enabled = true;
                }
                if ((f = FileUtil.getApplicationFile("javaw.exe.manifest")).exists()) {
                    valid = true;
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                valid = false;
            }
            enableXPStyle.setEnabled(valid);
            enableXPStyle.setSelection(enabled);
            enableXPStyle.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (enableXPStyle.getSelection()) {
                        try {
                            File fDest = new File(String.valueOf(System.getProperty("java.home")) + "\\bin\\javaw.exe.manifest");
                            File fOrigin = new File("javaw.exe.manifest");
                            if (!fDest.exists() && fOrigin.exists()) {
                                FileUtil.copyFile(fOrigin, fDest);
                            }
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    } else {
                        try {
                            File fDest = new File(String.valueOf(System.getProperty("java.home")) + "\\bin\\javaw.exe.manifest");
                            fDest.delete();
                        }
                        catch (Exception e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
        }
        if (Constants.isLinux && SWT.getPlatform().equals("gtk")) {
            new BooleanParameter(cLook, "SWT_bGTKTableBug", true, "ConfigView.section.style.verticaloffset");
        }
        new BooleanParameter(cLook, "GUI_SWT_bAlternateTablePainting", "ConfigView.section.style.alternateTablePainting");
        new BooleanParameter(cLook, "config.style.useSIUnits", false, "ConfigView.section.style.useSIUnits");
        new BooleanParameter(cLook, "config.style.useUnitsRateBits", false, "ConfigView.section.style.useUnitsRateBits");
        new BooleanParameter(cLook, "config.style.doNotUseGB", false, "ConfigView.section.style.doNotUseGB");
        Composite cArea = new Composite(cLook, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData());
        Label label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.colorScheme");
        ColorParameter colorScheme = new ColorParameter(cArea, "Color Scheme", 0, 128, 255);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        colorScheme.setLayoutData(gridData);
        Group cColorOverride = new Group(cArea, 0);
        Messages.setLanguageText((Widget)cColorOverride, "ConfigView.section.style.colorOverrides");
        layout = new GridLayout();
        layout.numColumns = 3;
        cColorOverride.setLayout((Layout)layout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        cColorOverride.setLayoutData((Object)gridData);
        int i = 0;
        while (i < sColorsToOverride.length) {
            String sConfigID = "Colors." + sColorsToOverride[i];
            label = new Label((Composite)cColorOverride, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.style.colorOverride." + sColorsToOverride[i]);
            ColorParameter colorParm = new ColorParameter((Composite)cColorOverride, sConfigID, this.colorsToOverride[i].getRed(), this.colorsToOverride[i].getGreen(), this.colorsToOverride[i].getBlue()){

                public void newColorChosen() {
                    COConfigurationManager.setParameter(String.valueOf(this.sParamName) + ".override", true);
                    int i = 0;
                    while (i < sColorsToOverride.length) {
                        if (this.sParamName.equals("Colors." + sColorsToOverride[i])) {
                            ConfigSectionInterfaceDisplay.this.btnColorReset[i].setEnabled(true);
                            break;
                        }
                        ++i;
                    }
                }
            };
            gridData = new GridData();
            gridData.widthHint = 50;
            colorParm.setLayoutData(gridData);
            this.btnColorReset[i] = new Button((Composite)cColorOverride, 8);
            Messages.setLanguageText((Widget)this.btnColorReset[i], "ConfigView.section.style.colorOverrides.reset");
            this.btnColorReset[i].setEnabled(COConfigurationManager.getBooleanParameter(String.valueOf(sConfigID) + ".override", false));
            this.btnColorReset[i].setData("ColorName", (Object)sConfigID);
            this.btnColorReset[i].addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Button btn = (Button)event.widget;
                    String sName = (String)btn.getData("ColorName");
                    if (sName != null) {
                        COConfigurationManager.setParameter(String.valueOf(sName) + ".override", false);
                        btn.setEnabled(false);
                    }
                }
            });
            ++i;
        }
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.guiUpdate");
        int[] values = new int[]{100, 250, 500, 1000, 2000, 5000};
        String[] labels = new String[]{"100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s"};
        new IntListParameter(cArea, "GUI Refresh", 1000, labels, values);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.graphicsUpdate");
        gridData = new GridData();
        gridData.widthHint = 15;
        IntParameter graphicUpdate = new IntParameter(cArea, "Graphics Update", 1, -1, false);
        graphicUpdate.setLayoutData(gridData);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.reOrderDelay");
        gridData = new GridData();
        gridData.widthHint = 15;
        IntParameter reorderDelay = new IntParameter(cArea, "ReOrder Delay");
        reorderDelay.setLayoutData(gridData);
        new BooleanParameter(cArea, "config.style.table.sortDefaultAscending", true, "ConfigView.section.style.sortDefaultAscending");
        return cLook;
    }
}

