/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.applet.Applet;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerException;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.ui.config.ConfigSectionSWT;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;

public class ConfigSectionInterface
implements ConfigSectionSWT {
    Label passwordMatch;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "style";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(final Composite parent) {
        Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cDisplay.setLayout((Layout)layout);
        new BooleanParameter(cDisplay, "Open Details", "ConfigView.label.opendetails");
        new BooleanParameter(cDisplay, "Open Bar", false, "ConfigView.label.openbar");
        if (!Constants.isOSX) {
            BooleanParameter est = new BooleanParameter(cDisplay, "Enable System Tray", true, "ConfigView.section.interface.enabletray");
            BooleanParameter ctt = new BooleanParameter(cDisplay, "Close To Tray", true, "ConfigView.label.closetotray");
            BooleanParameter mtt = new BooleanParameter(cDisplay, "Minimize To Tray", false, "ConfigView.label.minimizetotray");
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(ctt.getControls()));
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(mtt.getControls()));
        }
        new BooleanParameter(cDisplay, "Send Version Info", true, "ConfigView.label.allowSendVersion");
        Composite cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData());
        if (!Constants.isOSX) {
            BooleanParameter play_sound = new BooleanParameter(cArea, "Play Download Finished", false, "ConfigView.label.playdownloadfinished");
            Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
            gridData = new GridData();
            gridData.widthHint = 150;
            final StringParameter pathParameter = new StringParameter(cArea, "Play Download Finished File", "");
            if (pathParameter.getValue().length() == 0) {
                pathParameter.setValue("<default>");
            }
            pathParameter.setLayoutData(gridData);
            Button browse = new Button(cArea, 8);
            browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(browse.getBackground());
            browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog dialog = new FileDialog(parent.getShell(), 65536);
                    dialog.setFilterExtensions(new String[]{"*.wav"});
                    dialog.setFilterNames(new String[]{"*.wav"});
                    dialog.setText(MessageText.getString("ConfigView.section.interface.wavlocation"));
                    String path = dialog.open();
                    if (path != null) {
                        pathParameter.setValue(path);
                        new AEThread(this, "SoundTest", path){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ String val$path;
                            {
                                this.this$1 = var1_1;
                                this.val$path = string;
                                super($anonymous0);
                            }

                            public void runSupport() {
                                try {
                                    Applet.newAudioClip(new File(this.val$path).toURL()).play();
                                    Thread.sleep(2500L);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }.start();
                    }
                }
            });
            Label sound_info = new Label(cArea, 0);
            Messages.setLanguageText((Widget)sound_info, "ConfigView.section.interface.wavlocation.info");
            play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(pathParameter.getControls()));
            play_sound.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{browse, sound_info}));
            BooleanParameter confirm = new BooleanParameter(cArea, "confirmationOnExit", false, "ConfigView.section.style.confirmationOnExit");
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            confirm.setLayoutData(gridData);
        }
        BooleanParameter confirm_removal = new BooleanParameter(cArea, "confirm_torrent_removal", "ConfigView.section.interface.confirm_torrent_removal");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        confirm_removal.setLayoutData(gridData);
        Label label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.password");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw1 = new PasswordParameter(cArea, "Password");
        pw1.setLayoutData(gridData);
        Text t1 = (Text)pw1.getControl();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordconfirm");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw2 = new PasswordParameter(cArea, "Password Confirm");
        pw2.setLayoutData(gridData);
        Text t2 = (Text)pw2.getControl();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cArea, 0);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.passwordMatch.setLayoutData((Object)gridData);
        this.refreshPWLabel();
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        t1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.dropdiraction");
        String[] drop_options = new String[]{"ConfigView.section.style.dropdiraction.opentorrents", "ConfigView.section.style.dropdiraction.sharefolder", "ConfigView.section.style.dropdiraction.sharefoldercontents", "ConfigView.section.style.dropdiraction.sharefoldercontentsrecursive"};
        String[] dropLabels = new String[drop_options.length];
        String[] dropValues = new String[drop_options.length];
        int i = 0;
        while (i < drop_options.length) {
            dropLabels[i] = MessageText.getString(drop_options[i]);
            dropValues[i] = "" + i;
            ++i;
        }
        new StringListParameter(cArea, "config.style.dropdiraction", "", dropLabels, dropValues);
        label = new Label(cArea, 0);
        label = new Label(cArea, 0);
        try {
            final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform != null && platform.getPlatformType() == 1) {
                Composite cResetAssoc = new Composite(cArea, 0);
                layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 2;
                cResetAssoc.setLayout((Layout)layout);
                cResetAssoc.setLayoutData((Object)new GridData());
                label = new Label(cResetAssoc, 0);
                Messages.setLanguageText((Widget)label, "ConfigView.section.interface.resetassoc");
                Button reset = new Button(cResetAssoc, 8);
                Messages.setLanguageText((Widget)reset, "ConfigView.section.interface.resetassocbutton");
                reset.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        try {
                            platform.registerApplication();
                        }
                        catch (PlatformManagerException e) {
                            LGLogger.logUnrepeatableAlert("Failed to register application", e);
                        }
                    }
                });
                new BooleanParameter(cArea, "config.interface.checkassoc", true, "ConfigView.section.interface.checkassoc");
                label = new Label(cArea, 0);
                label = new Label(cArea, 0);
            }
        }
        catch (PlatformManagerException platformManagerException) {
            // empty catch block
        }
        return cDisplay;
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                int i = 0;
                while (i < password.length) {
                    if (password[i] != confirm[i]) {
                        same = false;
                    }
                    ++i;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

